/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.console.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.vertx.core.Handler;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.apache.camel.quarkus.component.console.CamelConsoleConfig;
import org.apache.camel.quarkus.component.console.CamelConsoleRecorder;
import org.apache.camel.quarkus.core.JvmOnlyRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextBuildItem;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={CamelConsoleEnabled.class})
class ConsoleProcessor {
    private static final Logger LOG = Logger.getLogger(ConsoleProcessor.class);
    private static final String FEATURE = "camel-console";

    ConsoleProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initDevConsoleRegistry(CamelContextBuildItem camelContext, CamelConsoleRecorder recorder) {
        recorder.initDevConsoleRegistry(camelContext.getCamelContext());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createManagementRoute(CamelContextBuildItem camelContext, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, BuildProducer<RouteBuildItem> routes, CamelConsoleConfig config, CamelConsoleRecorder recorder) {
        if (ConsoleProcessor.canExposeManagementEndpoint(config)) {
            Consumer route = recorder.route();
            Handler handler = recorder.getHandler(camelContext.getCamelContext());
            routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().routeFunction(config.path(), route).handler(handler).build());
            routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().routeFunction(config.path() + "/:id", route).handler(handler).build());
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void warnJvmInNative(JvmOnlyRecorder recorder) {
        JvmOnlyRecorder.warnJvmInNative((Logger)LOG, (String)FEATURE);
        recorder.warnJvmInNative(FEATURE);
    }

    private static boolean canExposeManagementEndpoint(CamelConsoleConfig config) {
        return LaunchMode.current().isDevOrTest() && config.exposureMode() == CamelConsoleConfig.ExposureMode.DEV_TEST || config.exposureMode().equals((Object)CamelConsoleConfig.ExposureMode.ALL);
    }

    static final class CamelConsoleEnabled
    implements BooleanSupplier {
        CamelConsoleConfig config;

        CamelConsoleEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled() || ConfigProvider.getConfig().getOptionalValue("camel.main.dev-console-enabled", Boolean.class).orElse(false) != false;
        }
    }
}

