/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.console;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.util.ObjectHelper;

@Recorder
public class CamelConsoleRecorder {
    public Consumer<Route> route() {
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.produces("application/json");
            }
        };
    }

    public Handler<RoutingContext> getHandler(RuntimeValue<CamelContext> contextRuntimeValue) {
        CamelContext context = (CamelContext)contextRuntimeValue.getValue();
        DevConsoleRegistry devConsoleRegistry = (DevConsoleRegistry)context.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class);
        return new CamelConsoleHandler(devConsoleRegistry);
    }

    public void initDevConsoleRegistry(RuntimeValue<CamelContext> camelContextRuntimeValue) {
        ((DevConsoleRegistry)((CamelContext)camelContextRuntimeValue.getValue()).getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).loadDevConsoles();
    }

    static final class CamelConsoleHandler
    implements Handler<RoutingContext> {
        private final DevConsoleRegistry devConsoleRegistry;

        CamelConsoleHandler(DevConsoleRegistry devConsoleRegistry) {
            this.devConsoleRegistry = devConsoleRegistry;
        }

        public void handle(RoutingContext context) {
            if (this.devConsoleRegistry != null && this.devConsoleRegistry.isEnabled()) {
                String id = context.pathParam("id");
                if (ObjectHelper.isNotEmpty((String)id)) {
                    this.getConsoleById(context, id);
                } else {
                    this.getConsoles(context);
                }
            }
        }

        void getConsoles(RoutingContext context) {
            JsonObject root = new JsonObject();
            this.devConsoleRegistry.stream().forEach(devConsole -> {
                JsonObject console = new JsonObject();
                console.put("id", (Object)devConsole.getId());
                console.put("displayName", (Object)devConsole.getDisplayName());
                console.put("description", (Object)devConsole.getDescription());
                root.put(devConsole.getId(), (Object)console);
            });
            this.writeResponse(context.response(), root);
        }

        void getConsoleById(RoutingContext context, String id) {
            JsonObject root = new JsonObject();
            this.devConsoleRegistry.stream().sorted((o1, o2) -> {
                int p1 = id.indexOf(o1.getId());
                int p2 = id.indexOf(o2.getId());
                return Integer.compare(p1, p2);
            }).forEach(devConsole -> {
                Object result;
                boolean include;
                boolean bl = include = "all".equals(id) || id.contains(devConsole.getId());
                if (include && devConsole.supportMediaType(DevConsole.MediaType.JSON) && (result = devConsole.call(DevConsole.MediaType.JSON, Map.of("CamelHttpPath", id))) != null) {
                    root.put(devConsole.getId(), result);
                }
            });
            this.writeResponse(context.response(), root);
        }

        void writeResponse(HttpServerResponse response, JsonObject jsonObject) {
            response.putHeader("Content-Type", "application/json");
            response.end(jsonObject.encode());
        }
    }
}

