/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cxf.soap.deployment;

import io.quarkiverse.cxf.deployment.CxfDeploymentUtils;
import io.quarkiverse.cxf.deployment.CxfEndpointImplementationBuildItem;
import io.quarkiverse.cxf.deployment.CxfRouteRegistrationRequestorBuildItem;
import io.quarkiverse.cxf.deployment.ServiceSeiBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.camel.quarkus.component.cxf.soap.deployment.CxfBuildTimeConfig;
import org.apache.camel.quarkus.core.deployment.util.PathFilter;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class CxfSoapProcessor {
    private static final String FEATURE = "camel-cxf-soap";

    CxfSoapProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    SystemPropertyBuildItem ehcacheAgentSizeOfBypass() {
        return new SystemPropertyBuildItem("org.ehcache.sizeof.AgentSizeOf.bypass", "true");
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods) {
        IndexView index = combinedIndex.getIndex();
        Stream.of("org.apache.wss4j.dom.handler.WSHandler").map(DotName::createSimple).flatMap(dotName -> index.getAllKnownSubclasses(dotName).stream()).map(classInfo -> classInfo.name().toString()).map(className -> ReflectiveClassBuildItem.builder((String[])new String[]{className}).build()).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory", "getServiceFactory", new String[0]));
    }

    @BuildStep
    void serviceSeis(CxfBuildTimeConfig cxfBuildTimeConfig, CombinedIndexBuildItem combinedIndex, List<CxfEndpointImplementationBuildItem> endpointImplementations, BuildProducer<ServiceSeiBuildItem> serviceSeis) {
        PathFilter.Builder b = new PathFilter.Builder();
        cxfBuildTimeConfig.classGeneration().excludePatterns().stream().map(pattern -> pattern.replace('.', '/')).forEach(arg_0 -> ((PathFilter.Builder)b).include(arg_0));
        Predicate seiFilter = b.build().asDotNamePredicate().negate();
        LinkedHashSet alreadyRegisteredInterfaces = new LinkedHashSet();
        IndexView index = combinedIndex.getIndex();
        endpointImplementations.stream().map(CxfEndpointImplementationBuildItem::getImplementor).forEach(impl -> CxfSoapProcessor.walkParents(index, DotName.createSimple((String)impl), alreadyRegisteredInterfaces));
        CxfDeploymentUtils.webServiceAnnotations((IndexView)index).map(annotation -> annotation.target().asClass()).filter(wsClassInfo -> Modifier.isInterface(wsClassInfo.flags())).map(ClassInfo::name).filter(seiFilter).map(DotName::toString).filter(intf -> !alreadyRegisteredInterfaces.contains(intf)).map(ServiceSeiBuildItem::new).forEach(arg_0 -> serviceSeis.produce(arg_0));
    }

    static void walkParents(IndexView index, DotName className, Set<String> alreadyRegisteredInterfaces) {
        if (className.toString().startsWith("java.")) {
            return;
        }
        ClassInfo cl = index.getClassByName(className);
        if (cl == null) {
            throw new IllegalStateException("Failed to look up " + String.valueOf(className) + " in Jandex");
        }
        if (Modifier.isInterface(cl.flags())) {
            alreadyRegisteredInterfaces.add(className.toString());
        }
        if (cl.superName() != null) {
            CxfSoapProcessor.walkParents(index, cl.superName(), alreadyRegisteredInterfaces);
        }
        cl.interfaceNames().forEach(intf -> CxfSoapProcessor.walkParents(index, intf, alreadyRegisteredInterfaces));
    }

    @BuildStep
    CxfRouteRegistrationRequestorBuildItem requestCxfRouteRegistration() {
        return new CxfRouteRegistrationRequestorBuildItem(FEATURE);
    }
}

