/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.debug.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AllowJNDIBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.util.function.BooleanSupplier;
import org.apache.camel.quarkus.component.debug.DebugConfig;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceDestination;
import org.apache.camel.quarkus.core.deployment.spi.CamelServicePatternBuildItem;
import org.eclipse.microprofile.config.ConfigProvider;

class DebugProcessor {
    private static final String FEATURE = "camel-debug";

    DebugProcessor() {
    }

    @BuildStep(onlyIf={DebugEnabled.class})
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={DebugEnabled.class})
    AllowJNDIBuildItem allowJNDI() {
        return new AllowJNDIBuildItem();
    }

    @BuildStep(onlyIfNot={DebugEnabled.class})
    CamelServicePatternBuildItem camelDebuggerFactoryServicePattern() {
        return new CamelServicePatternBuildItem(CamelServiceDestination.DISCOVERY, false, new String[]{"META-INF/services/org/apache/camel/debugger-factory"});
    }

    @BuildStep(onlyIf={DebugEnabled.class})
    void configureSystemProperties(BuildProducer<SystemPropertyBuildItem> producer, DebugConfig config) {
        producer.produce((BuildItem)new SystemPropertyBuildItem("org.apache.camel.debugger.suspend", Boolean.toString(config.suspend)));
        producer.produce((BuildItem)new SystemPropertyBuildItem("org.apache.camel.jmx.disabled", "false"));
    }

    static class DebugEnabled
    implements BooleanSupplier {
        DebugConfig config;
        LaunchMode launchMode;

        DebugEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.launchMode.equals((Object)LaunchMode.DEVELOPMENT) || this.config.enabled || ConfigProvider.getConfig().getOptionalValue("camel.debug.enabled", Boolean.TYPE).orElse(false) != false;
        }
    }
}

