/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment;

import ca.uhn.fhir.rest.client.apache.ApacheRestfulClientFactory;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.interceptor.CaptureResourceSourceFromHeaderInterceptor;
import ca.uhn.fhir.rest.server.interceptor.ResponseHighlighterInterceptor;
import ca.uhn.fhir.rest.server.interceptor.ResponseValidatingInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.SearchNarrowingInterceptor;
import ca.uhn.fhir.rest.server.interceptor.consent.ConsentInterceptor;
import ca.uhn.fhir.util.jar.DependencyLogImpl;
import ca.uhn.fhir.validation.schematron.SchematronBaseValidator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

final class FhirProcessor {
    private static final String FEATURE = "camel-fhir";
    private static final String[] INTERCEPTOR_CLASSES = new String[]{ConsentInterceptor.class.getName(), SearchNarrowingInterceptor.class.getName(), AuthorizationInterceptor.class.getName(), ResponseValidatingInterceptor.class.getName(), ResponseHighlighterInterceptor.class.getName(), CaptureResourceSourceFromHeaderInterceptor.class.getName(), IClientInterceptor.class.getName()};

    FhirProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageResourceBundleBuildItem hapiMessages() {
        return new NativeImageResourceBundleBuildItem("ca.uhn.fhir.i18n.hapi-messages");
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem hl7ArchiveMarker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("org/hl7/fhir");
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem hapiArchiveMarker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("ca/uhn/fhir");
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndex.getIndex();
        index.getAllKnownSubclasses(DotName.createSimple((String)BaseServerResponseException.class.getName())).stream().map(classInfo -> new ReflectiveClassBuildItem(false, false, new String[]{classInfo.name().toString()})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        String[] clientInterceptors = (String[])index.getAllKnownImplementors(DotName.createSimple((String)IClientInterceptor.class.getName())).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, clientInterceptors));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, INTERCEPTOR_CLASSES));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, true, new Class[]{SchematronBaseValidator.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, true, new Class[]{DependencyLogImpl.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new Class[]{ApacheRestfulClientFactory.class}));
    }
}

