/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment.dstu3;

import ca.uhn.fhir.context.FhirContext;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.HashSet;
import javax.inject.Singleton;
import org.apache.camel.quarkus.component.fhir.FhirContextRecorder;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.quarkus.component.fhir.deployment.FhirUtil;
import org.apache.camel.quarkus.component.fhir.deployment.dstu3.Dstu3PropertiesBuildItem;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BaseResource;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Resource;

public class FhirDstu3Processor {
    private static final String FHIR_VERSION_PROPERTIES = "org/hl7/fhir/dstu3/model/fhirversion.properties";

    @BuildStep(onlyIf={FhirFlags.Dstu3Enabled.class})
    Dstu3PropertiesBuildItem fhirProperties() {
        return new Dstu3PropertiesBuildItem(FHIR_VERSION_PROPERTIES);
    }

    @BuildStep(onlyIf={FhirFlags.Dstu3Enabled.class})
    NativeImageResourceBuildItem nativeImageResources() {
        return new NativeImageResourceBuildItem(new String[]{FHIR_VERSION_PROPERTIES});
    }

    @BuildStep(onlyIf={FhirFlags.Dstu3Enabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem recordFhirContext(FhirContextRecorder recorder, Dstu3PropertiesBuildItem propertiesBuildItem) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(FhirContext.class).scope(Singleton.class)).named("DSTU3")).runtimeValue(recorder.createDstu3FhirContext(FhirUtil.getResourceDefinitions(propertiesBuildItem.getProperties()))).done();
    }

    @BuildStep(onlyIf={FhirFlags.Dstu3Enabled.class})
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Dstu3PropertiesBuildItem propertiesBuildItem) {
        HashSet<String> classes = new HashSet<String>();
        classes.add(DomainResource.class.getName());
        classes.add(Resource.class.getName());
        classes.add(BaseResource.class.getName());
        classes.add(Base.class.getName());
        classes.addAll(FhirUtil.getModelClasses(propertiesBuildItem.getProperties()));
        classes.addAll(FhirUtil.getInnerClasses(Enumerations.class.getName()));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{Meta.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{MetadataResource.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, classes.toArray(new String[0])));
    }
}

