/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir;

import ca.uhn.fhir.context.FhirContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collection;

@Recorder
public class FhirContextRecorder {
    public RuntimeValue<FhirContext> createDstu2FhirContext(Collection<String> resourceDefinitions) {
        FhirContext fhirContext = FhirContext.forDstu2();
        this.initContext(resourceDefinitions, fhirContext);
        return new RuntimeValue((Object)fhirContext);
    }

    public RuntimeValue<FhirContext> createDstu2Hl7OrgFhirContext(Collection<String> resourceDefinitions) {
        FhirContext fhirContext = FhirContext.forDstu2Hl7Org();
        this.initContext(resourceDefinitions, fhirContext);
        return new RuntimeValue((Object)fhirContext);
    }

    public RuntimeValue<?> createDstu2_1FhirContext(Collection<String> resourceDefinitions) {
        FhirContext fhirContext = FhirContext.forDstu2_1();
        this.initContext(resourceDefinitions, fhirContext);
        return new RuntimeValue((Object)fhirContext);
    }

    public RuntimeValue<FhirContext> createDstu3FhirContext(Collection<String> resourceDefinitions) {
        FhirContext fhirContext = FhirContext.forDstu3();
        this.initContext(resourceDefinitions, fhirContext);
        return new RuntimeValue((Object)fhirContext);
    }

    public RuntimeValue<FhirContext> createR4FhirContext(Collection<String> resourceDefinitions) {
        FhirContext fhirContext = FhirContext.forR4();
        this.initContext(resourceDefinitions, fhirContext);
        return new RuntimeValue((Object)fhirContext);
    }

    public RuntimeValue<FhirContext> createR5FhirContext(Collection<String> resourceDefinitions) {
        FhirContext fhirContext = FhirContext.forR5();
        this.initContext(resourceDefinitions, fhirContext);
        return new RuntimeValue((Object)fhirContext);
    }

    private void initContext(Collection<String> resourceDefinitions, FhirContext fhirContext) {
        fhirContext.getElementDefinitions();
        for (String resourceDefinition : resourceDefinitions) {
            fhirContext.getResourceDefinition(resourceDefinition);
        }
    }
}

