/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.graphql.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import java.util.List;
import org.apache.camel.quarkus.component.graphql.CamelGraphQLConfig;

class GraphQLProcessor {
    private static final String FEATURE = "camel-graphql";

    GraphQLProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    void nativeImageResources(BuildProducer<NativeImageResourceBuildItem> nativeImage, CamelGraphQLConfig config) {
        if (!config.queryFiles.isPresent()) {
            return;
        }
        ((List)config.queryFiles.get()).stream().map(scriptFile -> new NativeImageResourceBuildItem(new String[]{scriptFile.replace("classpath:", "")})).forEach(arg_0 -> nativeImage.produce(arg_0));
    }
}

