/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.groovy.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.RuntimeValue;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.camel.language.groovy.GroovyLanguage;
import org.apache.camel.quarkus.component.groovy.deployment.GroovyExpressionSourceBuildItem;
import org.apache.camel.quarkus.component.groovy.runtime.GroovyExpressionRecorder;
import org.apache.camel.quarkus.component.groovy.runtime.GroovyStaticScript;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.support.language.deployment.ExpressionBuildItem;
import org.apache.camel.quarkus.support.language.deployment.ExpressionExtractionResultBuildItem;
import org.apache.camel.quarkus.support.language.deployment.ScriptBuildItem;
import org.apache.camel.quarkus.support.language.runtime.ExpressionUID;
import org.apache.camel.quarkus.support.language.runtime.ScriptUID;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.GroovyClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroovyProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyProcessor.class);
    private static final String PACKAGE_NAME = "org.apache.camel.quarkus.component.groovy.generated";
    private static final String SCRIPT_FORMAT = "package %s\n@groovy.transform.CompileStatic\nclass %s extends %s {\n  Object run() {\n    %s\n  }\n}\n";
    private static final String FEATURE = "camel-groovy";

    GroovyProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void collectExpressions(ExpressionExtractionResultBuildItem result, List<ExpressionBuildItem> expressions, List<ScriptBuildItem> scripts, BuildProducer<GroovyExpressionSourceBuildItem> producer) {
        if (result.isSuccess()) {
            String content;
            String name;
            ExpressionUID id;
            String original;
            List<ExpressionBuildItem> groovyExpressions = expressions.stream().filter(exp -> "groovy".equals(exp.getLanguage())).toList();
            List<ScriptBuildItem> groovyScripts = scripts.stream().filter(exp -> "groovy".equals(exp.getLanguage())).toList();
            if (groovyExpressions.isEmpty() && groovyScripts.isEmpty()) {
                return;
            }
            for (ExpressionBuildItem expression : groovyExpressions) {
                original = expression.getExpression();
                id = new ExpressionUID(original);
                name = String.format("%s.%s", PACKAGE_NAME, id);
                content = GroovyProcessor.toScriptClass(id.asJavaIdentifier(), expression.getLoadedExpression());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Extracting expression:\n\n{}\n", (Object)content);
                }
                producer.produce((BuildItem)new GroovyExpressionSourceBuildItem(name, original, content));
            }
            for (ScriptBuildItem script : groovyScripts) {
                original = script.getContent();
                id = new ScriptUID(original, script.getBindings(), new Object[0]);
                name = String.format("%s.%s", PACKAGE_NAME, id);
                content = GroovyProcessor.toScriptClass(id.asJavaIdentifier(), script.getLoadedContent());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Extracting script:\n\n{}\n", (Object)content);
                }
                producer.produce((BuildItem)new GroovyExpressionSourceBuildItem(name, original, content));
            }
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void compileScriptsAOT(CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, List<GroovyExpressionSourceBuildItem> sources, BuildProducer<GeneratedClassBuildItem> generatedClass) {
        if (sources.isEmpty()) {
            return;
        }
        CompilationUnit unit = new CompilationUnit();
        HashSet<String> classNames = new HashSet<String>();
        for (GroovyExpressionSourceBuildItem source : sources) {
            String name = source.getClassName();
            String content = source.getSourceCode();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compiling script:\n\n{}\n", (Object)content);
            }
            unit.addSource(name, content);
            classNames.add(name);
        }
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setClasspathList(curateOutcomeBuildItem.getApplicationModel().getDependencies().stream().map(ResolvedDependency::getResolvedPaths).flatMap(PathCollection::stream).map(Objects::toString).toList());
        unit.configure(cc);
        unit.compile(7);
        for (GroovyClass clazz : unit.getClasses()) {
            String className = clazz.getName();
            generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, className, clazz.getBytes()));
            if (!classNames.contains(className)) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).methods().fields().build());
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    CamelBeanBuildItem configureLanguage(GroovyExpressionRecorder recorder, ExpressionExtractionResultBuildItem result, List<GroovyExpressionSourceBuildItem> sources) {
        if (result.isSuccess() && !sources.isEmpty()) {
            RuntimeValue builder = recorder.languageBuilder();
            for (GroovyExpressionSourceBuildItem source : sources) {
                recorder.addScript(builder, source.getOriginalCode(), source.getClassName());
            }
            RuntimeValue language = recorder.languageNewInstance(builder);
            return new CamelBeanBuildItem("groovy", GroovyLanguage.class.getName(), language);
        }
        return null;
    }

    private static String toScriptClass(String name, String contentScript) {
        return String.format(SCRIPT_FORMAT, PACKAGE_NAME, name, GroovyStaticScript.class.getName(), contentScript);
    }
}

