/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.grpc.codegen;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.quarkus.deployment.util.ProcessUtil;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathFilter;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.utilities.OS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.camel.quarkus.grpc.codegen.CamelQuarkusGrpcPostProcessor;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public class CamelQuarkusGrpcCodegenProvider
implements CodeGenProvider {
    private static final Logger LOG = Logger.getLogger(CamelQuarkusGrpcCodegenProvider.class);
    private static final String EXE = "exe";
    private static final String PROTO = ".proto";
    private static final String PROTOC = "protoc";
    private static final String PROTOC_GROUP_ID = "com.google.protobuf";
    private static final String SCAN_DEPENDENCIES_FOR_PROTO = "quarkus.camel.grpc.codegen.scan-for-proto";
    private static final String SCAN_DEPENDENCIES_FOR_PROTO_INCLUDE_PATTERN = "quarkus.camel.grpc.codegen.scan-for-proto-includes.\"%s\"";
    private static final String SCAN_DEPENDENCIES_FOR_PROTO_EXCLUDE_PATTERN = "quarkus.camel.grpc.codegen.scan-for-proto-excludes.\"%s\"";
    private static final String SCAN_FOR_IMPORTS = "quarkus.camel.grpc.codegen.scan-for-imports";
    private Executables executables;

    public String providerId() {
        return "camel-quarkus-grpc";
    }

    public String inputExtension() {
        return "proto";
    }

    public String inputDirectory() {
        return "proto";
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        Config config = context.config();
        if (!((Boolean)config.getValue("quarkus.camel.grpc.codegen.enabled", Boolean.class)).booleanValue()) {
            LOG.info((Object)("Skipping " + String.valueOf(this.getClass()) + " invocation on user's request"));
            return false;
        }
        Path outDir = context.outDir();
        Path workDir = context.workDir();
        HashSet<String> protoDirs = new HashSet<String>();
        try {
            Path dirWithProtosFromDependencies;
            Collection<Path> protoFilesFromDependencies;
            ArrayList protoFiles = new ArrayList();
            if (Files.isDirectory(context.inputDir(), new LinkOption[0])) {
                try (Stream<Path> protoFilesPaths = Files.walk(context.inputDir(), new FileVisitOption[0]);){
                    protoFilesPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(s -> s.toString().endsWith(PROTO)).map(Path::normalize).map(Path::toAbsolutePath).map(Path::toString).forEach(protoFiles::add);
                    protoDirs.add(context.inputDir().normalize().toAbsolutePath().toString());
                }
            }
            if (!(protoFilesFromDependencies = this.gatherProtosFromDependencies(dirWithProtosFromDependencies = workDir.resolve("protoc-protos-from-dependencies"), protoDirs, context)).isEmpty()) {
                protoFilesFromDependencies.stream().map(Path::normalize).map(Path::toAbsolutePath).map(Path::toString).forEach(protoFiles::add);
            }
            if (!protoFiles.isEmpty()) {
                this.initExecutables(workDir, context.applicationModel());
                Path protocDependenciesDir = workDir.resolve("protoc-dependencies");
                Collection<String> protosToImport = this.gatherDirectoriesWithImports(protocDependenciesDir, context);
                if (!protoFilesFromDependencies.isEmpty() && !protosToImport.isEmpty()) {
                    protoFiles.forEach(file -> {
                        if (!file.contains(context.inputDir().toString())) {
                            String relativeFileName = file.replace(dirWithProtosFromDependencies.toString(), "");
                            Path path = Paths.get(protocDependenciesDir.toAbsolutePath().toString(), relativeFileName);
                            if (Files.exists(path, new LinkOption[0])) {
                                LOG.debugf("Cleaning up duplicate proto file %s", (Object)path);
                                try {
                                    Files.delete(path);
                                }
                                catch (IOException e) {
                                    LOG.errorf("Failed cleaning up duplicate proto file %s", (Object)e);
                                }
                            }
                        }
                    });
                }
                ArrayList<String> command = new ArrayList<String>();
                command.add(this.executables.protoc.toString());
                for (String protoImportDir : protosToImport) {
                    command.add(String.format("-I=%s", this.escapeWhitespace(protoImportDir)));
                }
                for (String protoDir : protoDirs) {
                    command.add(String.format("-I=%s", this.escapeWhitespace(protoDir)));
                }
                command.addAll(Arrays.asList("--plugin=protoc-gen-grpc=" + String.valueOf(this.executables.grpc), "--grpc_out=" + String.valueOf(outDir), "--java_out=" + String.valueOf(outDir)));
                command.addAll(protoFiles);
                ProcessBuilder processBuilder = new ProcessBuilder(command);
                Process process = ProcessUtil.launchProcess((ProcessBuilder)processBuilder, (boolean)context.shouldRedirectIO());
                int resultCode = process.waitFor();
                if (resultCode != 0) {
                    throw new CodeGenException("Failed to generate Java classes from proto files: " + String.valueOf(protoFiles) + " to " + String.valueOf(outDir.toAbsolutePath()) + " with command " + String.join((CharSequence)" ", command));
                }
                new CamelQuarkusGrpcPostProcessor(outDir).process();
                LOG.info((Object)"Successfully finished generating and post-processing sources from proto files");
                return true;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new CodeGenException("Failed to generate java files from proto file in " + String.valueOf(context.inputDir().toAbsolutePath()), (Throwable)e);
        }
        return false;
    }

    private static void copySanitizedProtoFile(ResolvedDependency artifact, Path protoPath, Path outProtoPath) throws IOException {
        boolean genericServicesFound = false;
        try (BufferedReader reader = Files.newBufferedReader(protoPath);
             BufferedWriter writer = Files.newBufferedWriter(outProtoPath, new OpenOption[0]);){
            String line = reader.readLine();
            while (line != null) {
                if (!line.contains("java_generic_services")) {
                    writer.write(line);
                    writer.newLine();
                } else {
                    genericServicesFound = true;
                }
                line = reader.readLine();
            }
        }
        if (genericServicesFound) {
            LOG.infof("Ignoring option java_generic_services in %s:%s%s.", (Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), (Object)protoPath);
        }
    }

    private Collection<Path> gatherProtosFromDependencies(Path workDir, Set<String> protoDirectories, CodeGenContext context) throws CodeGenException {
        if (context.test()) {
            return Collections.emptyList();
        }
        Config properties = context.config();
        String scanDependencies = (String)properties.getValue(SCAN_DEPENDENCIES_FOR_PROTO, String.class);
        if ("none".equalsIgnoreCase(scanDependencies)) {
            return Collections.emptyList();
        }
        boolean scanAll = "all".equalsIgnoreCase(scanDependencies);
        List<String> dependenciesToScan = Arrays.asList(scanDependencies.split(","));
        ApplicationModel appModel = context.applicationModel();
        ArrayList<Path> protoFilesFromDependencies = new ArrayList<Path>();
        for (ResolvedDependency artifact : appModel.getRuntimeDependencies()) {
            String packageId = String.format("%s:%s", artifact.getGroupId(), artifact.getArtifactId());
            Collection includes = properties.getOptionalValues(String.format(SCAN_DEPENDENCIES_FOR_PROTO_INCLUDE_PATTERN, packageId), String.class).orElse(List.of());
            Collection excludes = properties.getOptionalValues(String.format(SCAN_DEPENDENCIES_FOR_PROTO_EXCLUDE_PATTERN, packageId), String.class).orElse(List.of());
            if (!scanAll && !dependenciesToScan.contains(packageId)) continue;
            this.extractProtosFromArtifact(workDir, protoFilesFromDependencies, protoDirectories, artifact, includes, excludes, true);
        }
        return protoFilesFromDependencies;
    }

    public boolean shouldRun(Path sourceDir, Config config) {
        return super.shouldRun(sourceDir, config) || this.isGeneratingFromAppDependenciesEnabled(config);
    }

    private boolean isGeneratingFromAppDependenciesEnabled(Config config) {
        return config.getOptionalValue(SCAN_DEPENDENCIES_FOR_PROTO, String.class).filter(value -> !"none".equals(value)).isPresent();
    }

    private Collection<String> gatherDirectoriesWithImports(Path workDir, CodeGenContext context) throws CodeGenException {
        Config properties = context.config();
        String scanForImports = properties.getOptionalValue(SCAN_FOR_IMPORTS, String.class).orElse("com.google.protobuf:protobuf-java");
        if ("none".equals(scanForImports.toLowerCase(Locale.getDefault()))) {
            return Collections.emptyList();
        }
        boolean scanAll = "all".equals(scanForImports.toLowerCase(Locale.getDefault()));
        List<String> dependenciesToScan = Arrays.asList(scanForImports.split(","));
        HashSet<String> importDirectories = new HashSet<String>();
        ApplicationModel appModel = context.applicationModel();
        for (ResolvedDependency artifact : appModel.getRuntimeDependencies()) {
            if (!scanAll && !dependenciesToScan.contains(String.format("%s:%s", artifact.getGroupId(), artifact.getArtifactId()))) continue;
            this.extractProtosFromArtifact(workDir, new ArrayList<Path>(), importDirectories, artifact, List.of(), List.of(), false);
        }
        return importDirectories;
    }

    private void extractProtosFromArtifact(Path workDir, Collection<Path> protoFiles, Set<String> protoDirectories, ResolvedDependency artifact, Collection<String> filesToInclude, Collection<String> filesToExclude, boolean isDependency) throws CodeGenException {
        try {
            artifact.getContentTree(new PathFilter(filesToInclude, filesToExclude)).walk(pathVisit -> {
                Path path = pathVisit.getPath();
                if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(PROTO)) {
                    Path root = pathVisit.getRoot();
                    if (Files.isDirectory(root, new LinkOption[0])) {
                        protoFiles.add(path);
                        protoDirectories.add(path.getParent().normalize().toAbsolutePath().toString());
                    } else {
                        Path relativePath = path.getRoot().relativize(path);
                        Path protoUnzipDir = workDir.resolve(HashUtil.sha1((String)root.normalize().toAbsolutePath().toString())).normalize().toAbsolutePath();
                        try {
                            Files.createDirectories(protoUnzipDir, new FileAttribute[0]);
                            protoDirectories.add(protoUnzipDir.toString());
                        }
                        catch (IOException e) {
                            throw new GrpcCodeGenException("Failed to create directory: " + String.valueOf(protoUnzipDir), e);
                        }
                        Path outPath = protoUnzipDir;
                        for (Path part : relativePath) {
                            outPath = outPath.resolve(part.toString());
                        }
                        try {
                            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                            if (isDependency) {
                                CamelQuarkusGrpcCodegenProvider.copySanitizedProtoFile(artifact, path, outPath);
                            } else {
                                Files.copy(path, outPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                            protoFiles.add(outPath);
                        }
                        catch (IOException e) {
                            throw new GrpcCodeGenException("Failed to extract proto file" + String.valueOf(path) + " to target: " + String.valueOf(outPath), e);
                        }
                    }
                }
            });
        }
        catch (GrpcCodeGenException e) {
            throw new CodeGenException(e.getMessage(), (Throwable)e);
        }
    }

    private String escapeWhitespace(String path) {
        if (OS.determineOS() == OS.LINUX) {
            return path.replace(" ", "\\ ");
        }
        return path;
    }

    private void initExecutables(Path workDir, ApplicationModel model) throws CodeGenException {
        if (this.executables == null) {
            String protocPathProperty = System.getProperty("quarkus.grpc.protoc-path");
            String classifier = System.getProperty("quarkus.grpc.protoc-os-classifier", this.osClassifier());
            Path protocPath = protocPathProperty == null ? CamelQuarkusGrpcCodegenProvider.findArtifactPath(model, PROTOC_GROUP_ID, PROTOC, classifier, EXE) : Paths.get(protocPathProperty, new String[0]);
            Path protocExe = this.makeExecutableFromPath(workDir, PROTOC_GROUP_ID, PROTOC, classifier, EXE, protocPath);
            Path protocGrpcPluginExe = this.prepareExecutable(workDir, model, "io.grpc", "protoc-gen-grpc-java", classifier, EXE);
            this.executables = new Executables(protocExe, protocGrpcPluginExe);
        }
    }

    private Path prepareExecutable(Path buildDir, ApplicationModel model, String groupId, String artifactId, String classifier, String packaging) throws CodeGenException {
        Path artifactPath = CamelQuarkusGrpcCodegenProvider.findArtifactPath(model, groupId, artifactId, classifier, packaging);
        return this.makeExecutableFromPath(buildDir, groupId, artifactId, classifier, packaging, artifactPath);
    }

    private Path makeExecutableFromPath(Path buildDir, String groupId, String artifactId, String classifier, String packaging, Path artifactPath) throws CodeGenException {
        Path exe = buildDir.resolve(String.format("%s-%s-%s-%s", groupId, artifactId, classifier, packaging));
        if (Files.exists(exe, new LinkOption[0])) {
            return exe;
        }
        if (artifactPath == null) {
            String location = String.format("%s:%s:%s:%s", groupId, artifactId, classifier, packaging);
            throw new CodeGenException("Failed to find " + location + " among dependencies");
        }
        try {
            Files.copy(artifactPath, exe, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to copy file: " + String.valueOf(artifactPath) + " to " + String.valueOf(exe), (Throwable)e);
        }
        if (!exe.toFile().setExecutable(true)) {
            throw new CodeGenException("Failed to make the file executable: " + String.valueOf(exe));
        }
        return exe;
    }

    private static Path findArtifactPath(ApplicationModel model, String groupId, String artifactId, String classifier, String packaging) {
        Path artifactPath = null;
        for (ResolvedDependency artifact : model.getDependencies()) {
            if (!groupId.equals(artifact.getGroupId()) || !artifactId.equals(artifact.getArtifactId()) || !classifier.equals(artifact.getClassifier()) || !packaging.equals(artifact.getType())) continue;
            artifactPath = artifact.getResolvedPaths().getSinglePath();
        }
        return artifactPath;
    }

    private String osClassifier() throws CodeGenException {
        String architecture = OS.getArchitecture();
        switch (OS.determineOS()) {
            case LINUX: {
                return "linux-" + architecture;
            }
            case WINDOWS: {
                return "windows-" + architecture;
            }
            case MAC: {
                return "osx-" + architecture;
            }
        }
        throw new CodeGenException("Unsupported OS, please use maven plugin instead to generate Java classes from proto files");
    }

    private static class Executables {
        final Path protoc;
        final Path grpc;

        Executables(Path protoc, Path grpc) {
            this.protoc = protoc;
            this.grpc = grpc;
        }
    }

    private static class GrpcCodeGenException
    extends RuntimeException {
        private GrpcCodeGenException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

