/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.grpc.runtime;

import io.grpc.BindableService;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.camel.CamelContext;
import org.apache.camel.component.grpc.GrpcConsumer;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.GrpcUtils;
import org.apache.camel.component.grpc.server.BindableServiceFactory;
import org.apache.camel.component.grpc.server.GrpcMethodHandler;
import org.apache.camel.quarkus.grpc.runtime.CamelQuarkusBindableService;

@Singleton
@Named(value="grpcBindableServiceFactory")
public class QuarkusBindableServiceFactory
implements BindableServiceFactory {
    @Inject
    Instance<CamelQuarkusBindableService> bindableServices;

    public BindableService createBindableService(GrpcConsumer consumer) {
        GrpcEndpoint endpoint = (GrpcEndpoint)consumer.getEndpoint();
        CamelContext camelContext = endpoint.getCamelContext();
        Class baseClass = GrpcUtils.constructGrpcImplBaseClass((String)endpoint.getServicePackage(), (String)endpoint.getServiceName(), (CamelContext)camelContext);
        CamelQuarkusBindableService bindableService = this.bindableServices.stream().filter(service -> baseClass.isAssignableFrom(service.getClass())).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find generated class for service " + endpoint.getServiceName()));
        GrpcMethodHandler methodHandler = new GrpcMethodHandler(consumer);
        bindableService.setMethodHandler(methodHandler);
        return bindableService;
    }
}

