/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hazelcast.deployment;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.internal.util.ICMPHelper;
import com.hazelcast.internal.util.OperatingSystemMXBeanSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.topic.ITopic;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.utilities.OS;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.TrustManager;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.tooling.model.MainModel;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class HazelcastProcessor {
    private static final String FEATURE = "camel-hazelcast";

    HazelcastProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerReflectiveClasses() {
        ArrayList<ReflectiveClassBuildItem> items = new ArrayList<ReflectiveClassBuildItem>();
        items.add(ReflectiveClassBuildItem.builder((String[])new String[]{HazelcastInstance.class.getName()}).fields().build());
        items.add(ReflectiveClassBuildItem.builder((String[])new String[]{Config.class.getName()}).fields().build());
        items.add(ReflectiveClassBuildItem.builder((String[])new String[]{ClientConfig.class.getName()}).fields().build());
        return items;
    }

    @BuildStep
    void registerCustomImplementationClasses(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, IList.class, IQueue.class, ISet.class, HazelcastInstance.class, IAtomicLong.class, IMap.class, MultiMap.class, ReplicatedMap.class, Ringbuffer.class, ITopic.class, MBeanServer.class, Context.class, KeyManager.class, SNIServerName.class, TrustManager.class, XPathFactory.class, MainModel.class);
    }

    @BuildStep
    void registerICMPHelper(BuildProducer<RuntimeInitializedClassBuildItem> initializedClasses) {
        if (OS.determineOS() != OS.LINUX) {
            initializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(ICMPHelper.class.getName()));
        }
        initializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(OperatingSystemMXBeanSupport.class.getName()));
    }

    private static void registerTypeHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings, Class<?> ... classNames) {
        for (Class<?> klass : classNames) {
            DotName simpleName = DotName.createSimple((String)klass.getName());
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(Type.create((DotName)simpleName, (Type.Kind)Type.Kind.CLASS)).build());
            ignoreWarnings.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(simpleName));
        }
    }
}

