/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hl7.deployment;

import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import org.apache.camel.component.hl7.Hl7Terser;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class Hl7Processor {
    private static final String FEATURE = "camel-hl7";
    private static final String CA_UHN_HAPI_GROUP_ID = "ca.uhn.hapi";

    Hl7Processor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> indexedDependency, CurateOutcomeBuildItem curateOutcome) {
        curateOutcome.getApplicationModel().getDependencies().stream().filter(appArtifact -> appArtifact.getGroupId().equals(CA_UHN_HAPI_GROUP_ID) && appArtifact.getArtifactId().startsWith("hapi-structures-")).map(appArtifact -> new IndexDependencyBuildItem(appArtifact.getGroupId(), appArtifact.getArtifactId())).forEach(arg_0 -> indexedDependency.produce(arg_0));
        indexedDependency.produce((BuildItem)new IndexDependencyBuildItem(CA_UHN_HAPI_GROUP_ID, "hapi-base"));
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] hapiStructureClasses = (String[])index.getAllKnownImplementors(DotName.createSimple((String)Structure.class.getName())).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        String[] hapiTypeClasses = (String[])index.getAllKnownImplementors(DotName.createSimple((String)Type.class.getName())).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])hapiStructureClasses).fields().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])hapiTypeClasses).fields().build());
        String[] terserBeans = (String[])index.getAnnotations(DotName.createSimple((String)Hl7Terser.class.getName())).stream().map(AnnotationInstance::target).map(annotationTarget -> {
            if (annotationTarget.kind().equals((Object)AnnotationTarget.Kind.FIELD)) {
                return annotationTarget.asType().asClass();
            }
            if (annotationTarget.kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
                return annotationTarget.asMethod().declaringClass();
            }
            if (annotationTarget.kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER)) {
                return annotationTarget.asMethodParameter().method().declaringClass();
            }
            return null;
        }).filter(CamelSupport::isConcrete).map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])terserBeans).methods().build());
    }
}

