/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.function.BooleanSupplier;
import org.apache.camel.quarkus.component.jasypt.CamelJasyptBuildTimeConfig;
import org.apache.camel.quarkus.component.jasypt.CamelJasyptRecorder;
import org.apache.camel.quarkus.component.jasypt.CamelJasyptRuntimeConfigBuilder;
import org.apache.camel.quarkus.component.jasypt.JasyptConfigurationCustomizer;
import org.apache.camel.quarkus.core.deployment.main.spi.CamelMainBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.RuntimeCamelContextCustomizerBuildItem;
import org.jboss.jandex.ClassInfo;

class JasyptProcessor {
    private static final String FEATURE = "camel-jasypt";

    JasyptProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        combinedIndex.getIndex().getAllKnownImplementors(JasyptConfigurationCustomizer.class).stream().map(ClassInfo::name).forEach(className -> reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className.toString()}).build()));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={CamelJasyptEnabled.class})
    void disableCamelMainAutoConfigFromSysEnv(CamelMainBuildItem camelMain, CamelJasyptRecorder recorder) {
        recorder.disableCamelMainAutoConfigFromSysEnv(camelMain.getInstance());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={CamelJasyptEnabled.class})
    RuntimeCamelContextCustomizerBuildItem propertiesComponentRuntimeCamelContextCustomizer(CamelJasyptRecorder recorder) {
        return new RuntimeCamelContextCustomizerBuildItem(recorder.createPropertiesComponentCamelContextCustomizer());
    }

    @BuildStep(onlyIf={CamelJasyptEnabled.class})
    RunTimeConfigBuilderBuildItem jasyptRuntimeConfigBuilder() {
        return new RunTimeConfigBuilderBuildItem(CamelJasyptRuntimeConfigBuilder.class.getName());
    }

    static final class CamelJasyptEnabled
    implements BooleanSupplier {
        CamelJasyptBuildTimeConfig config;

        CamelJasyptEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled();
        }
    }
}

