/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt;

import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.quarkus.component.jasypt.JasyptConfigurationCustomizer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.NoIvGenerator;
import org.jasypt.iv.RandomIvGenerator;
import org.jasypt.salt.RandomSaltGenerator;
import org.jasypt.salt.SaltGenerator;

@ConfigMapping(prefix="quarkus.camel.jasypt")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface CamelJasyptConfig {
    public static final String NAME = "camel-jasypt";
    public static final String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
    public static final String SYS_CONFIG_PREFIX = "sys:";
    public static final String SYS_ENV_CONFIG_PREFIX = "sysenv:";
    public static final Set<String> ALGORITHMS_THAT_REQUIRE_IV = Set.of("PBEWITHHMACSHA1ANDAES_128", "PBEWITHHMACSHA1ANDAES_256", "PBEWITHHMACSHA224ANDAES_128", "PBEWITHHMACSHA224ANDAES_256", "PBEWITHHMACSHA256ANDAES_128", "PBEWITHHMACSHA256ANDAES_256", "PBEWITHHMACSHA384ANDAES_128", "PBEWITHHMACSHA384ANDAES_256", "PBEWITHHMACSHA512ANDAES_128", "PBEWITHHMACSHA512ANDAES_256");

    @WithDefault(value="PBEWithMD5AndDES")
    public String algorithm();

    public Optional<String> password();

    @WithDefault(value="SHA1PRNG")
    public String randomIvGeneratorAlgorithm();

    @WithDefault(value="SHA1PRNG")
    public String randomSaltGeneratorAlgorithm();

    public Optional<String> configurationCustomizerClassName();

    default public PBEConfig pbeConfig() {
        EnvironmentStringPBEConfig config = new EnvironmentStringPBEConfig();
        String password = null;
        if (this.password().isPresent() && ObjectHelper.isNotEmpty((String)(password = this.password().get()))) {
            if (password.startsWith(SYS_ENV_CONFIG_PREFIX)) {
                password = System.getenv(StringHelper.after((String)password, (String)SYS_ENV_CONFIG_PREFIX));
            } else if (password.startsWith(SYS_CONFIG_PREFIX)) {
                password = System.getProperty(StringHelper.after((String)password, (String)SYS_CONFIG_PREFIX));
            }
        }
        config.setPassword(password);
        config.setAlgorithm(this.algorithm());
        config.setIvGenerator((IvGenerator)(ALGORITHMS_THAT_REQUIRE_IV.contains(this.algorithm().toUpperCase()) ? new RandomIvGenerator(this.randomIvGeneratorAlgorithm()) : new NoIvGenerator()));
        config.setSaltGenerator((SaltGenerator)new RandomSaltGenerator(this.randomSaltGeneratorAlgorithm()));
        if (this.configurationCustomizerClassName().isPresent()) {
            try {
                Class<?> encryptorClass = Thread.currentThread().getContextClassLoader().loadClass(this.configurationCustomizerClassName().get());
                JasyptConfigurationCustomizer customizer = (JasyptConfigurationCustomizer)encryptorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                customizer.customize(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            config.getPassword();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("The jasypt password has not been configured.");
        }
        return config;
    }
}

