/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import java.util.OptionalInt;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class CamelJasyptConfigSourceInterceptorFactory
implements ConfigSourceInterceptorFactory {
    public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
        return new ConfigSourceInterceptor(){

            public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
                String value;
                ConfigValue configValue = context.proceed(name);
                if (configValue != null && PropertyValueEncryptionUtils.isEncryptedValue((String)(value = configValue.getValue()))) {
                    return configValue.withValue("${camel-jasypt::%s}".formatted(value));
                }
                return configValue;
            }
        };
    }

    public OptionalInt getPriority() {
        return OptionalInt.of(3000);
    }
}

