/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jasypt.JasyptPropertiesParser;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.quarkus.component.jasypt.CamelJasyptPropertiesParserHolder;
import org.apache.camel.quarkus.main.CamelMain;
import org.apache.camel.spi.CamelContextCustomizer;

@Recorder
public class CamelJasyptRecorder {
    public void disableCamelMainAutoConfigFromSysEnv(RuntimeValue<CamelMain> camelMainRuntimeValue) {
        CamelMain main = (CamelMain)camelMainRuntimeValue.getValue();
        MainConfigurationProperties configurationProperties = main.getMainConfigurationProperties();
        configurationProperties.setAutoConfigurationSystemPropertiesEnabled(false);
        configurationProperties.setAutoConfigurationEnvironmentVariablesEnabled(false);
    }

    public RuntimeValue<CamelContextCustomizer> createPropertiesComponentCamelContextCustomizer() {
        return new RuntimeValue((Object)new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                PropertiesComponent component = (PropertiesComponent)camelContext.getPropertiesComponent();
                JasyptPropertiesParser jasyptPropertiesParser = CamelJasyptPropertiesParserHolder.getJasyptPropertiesParser();
                jasyptPropertiesParser.setPropertiesComponent(component);
                component.setPropertiesParser((PropertiesParser)jasyptPropertiesParser);
            }
        });
    }
}

