/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import org.apache.camel.component.jasypt.JasyptPropertiesParser;
import org.apache.camel.quarkus.component.jasypt.CamelJasyptBuildTimeConfig;
import org.apache.camel.quarkus.component.jasypt.CamelJasyptConfig;
import org.apache.camel.quarkus.component.jasypt.CamelJasyptPropertiesParserHolder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public class CamelJasyptSecretKeysHandlerFactory
implements SecretKeysHandlerFactory {
    private final JasyptPropertiesParser parser = CamelJasyptPropertiesParserHolder.getJasyptPropertiesParser();

    public SecretKeysHandler getSecretKeysHandler(ConfigSourceContext context) {
        return new SecretKeysHandlerFactory.LazySecretKeysHandler(new SecretKeysHandlerFactory(){

            public SecretKeysHandler getSecretKeysHandler(ConfigSourceContext context) {
                SmallRyeConfig config = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigSourceContext.ConfigSourceContextConfigSource(context)}).withMapping(CamelJasyptConfig.class).withMapping(CamelJasyptBuildTimeConfig.class).build();
                CamelJasyptConfig jasyptConfig = (CamelJasyptConfig)config.getConfigMapping(CamelJasyptConfig.class);
                StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
                encryptor.setConfig(jasyptConfig.pbeConfig());
                CamelJasyptPropertiesParserHolder.setEncryptor(encryptor);
                return new SecretKeysHandler(){

                    public String decode(String secret) {
                        return CamelJasyptSecretKeysHandlerFactory.this.parser.parseProperty("", secret, null);
                    }

                    public String getName() {
                        return CamelJasyptSecretKeysHandlerFactory.this.getName();
                    }
                };
            }

            public String getName() {
                return CamelJasyptSecretKeysHandlerFactory.this.getName();
            }
        });
    }

    public String getName() {
        return "camel-jasypt";
    }
}

