/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import java.security.SecureRandom;
import java.text.Normalizer;
import org.apache.camel.quarkus.component.jasypt.graal.SecureRandomAccessor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.iv.RandomIvGenerator;
import org.jasypt.normalization.Normalizer;
import org.jasypt.salt.RandomSaltGenerator;

public class JasyptSubstitutions {

    @TargetClass(value=RandomSaltGenerator.class)
    static final class RandomSaltGeneratorSubstitutions {
        @Alias
        @InjectAccessors(value=SecureRandomAccessor.class)
        private SecureRandom random;
        @Inject
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        String secureRandomAlgorithm;

        @Substitute
        @TargetElement(name="<init>")
        public RandomSaltGeneratorSubstitutions(String secureRandomAlgorithm) {
            this.secureRandomAlgorithm = secureRandomAlgorithm;
        }
    }

    @TargetClass(value=RandomIvGenerator.class)
    static final class RandomIvGeneratorSubstitutions {
        @Alias
        @InjectAccessors(value=SecureRandomAccessor.class)
        private SecureRandom random;
        @Inject
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        String secureRandomAlgorithm;

        @Substitute
        @TargetElement(name="<init>")
        public RandomIvGeneratorSubstitutions(String secureRandomAlgorithm) {
            this.secureRandomAlgorithm = secureRandomAlgorithm;
        }
    }

    @TargetClass(value=Normalizer.class)
    static final class NormalizerSubstitutions {
        NormalizerSubstitutions() {
        }

        @Substitute
        public static char[] normalizeToNfc(char[] message) {
            String result;
            String messageStr = new String(message);
            try {
                result = java.text.Normalizer.normalize(messageStr, Normalizer.Form.NFC);
            }
            catch (Exception e) {
                throw new EncryptionInitializationException("Could not perform a valid UNICODE normalization", (Throwable)e);
            }
            return result.toCharArray();
        }
    }
}

