/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt.graal;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.camel.quarkus.component.jasypt.graal.JasyptSubstitutions;
import org.jasypt.exceptions.EncryptionInitializationException;

class SecureRandomAccessor {
    private static volatile SecureRandom RANDOM;
    private static final String DEFAULT_ALGORITHM = "SHA1PRNG";

    SecureRandomAccessor() {
    }

    static SecureRandom get(Object instance) {
        SecureRandom result = RANDOM;
        if (result == null) {
            result = SecureRandomAccessor.initializeOnce(SecureRandomAccessor.getAlgorithm(instance));
        }
        return result;
    }

    static void set(Object instance, SecureRandom secureRandom) {
        throw new UnsupportedOperationException();
    }

    private static synchronized SecureRandom initializeOnce(String algorithm) {
        SecureRandom result = RANDOM;
        if (result != null) {
            return result;
        }
        try {
            RANDOM = result = SecureRandom.getInstance(algorithm);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionInitializationException((Throwable)e);
        }
    }

    private static String getAlgorithm(Object instance) {
        if (instance instanceof JasyptSubstitutions.RandomIvGeneratorSubstitutions) {
            return ((JasyptSubstitutions.RandomIvGeneratorSubstitutions)instance).secureRandomAlgorithm;
        }
        if (instance instanceof JasyptSubstitutions.RandomSaltGeneratorSubstitutions) {
            return ((JasyptSubstitutions.RandomSaltGeneratorSubstitutions)instance).secureRandomAlgorithm;
        }
        return DEFAULT_ALGORITHM;
    }
}

