/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jpa.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import jakarta.persistence.EntityManagerFactory;
import java.util.List;
import org.apache.camel.component.jpa.JpaComponent;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.quarkus.component.jpa.CamelJpaProducer;
import org.apache.camel.quarkus.component.jpa.CamelJpaRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanQualifierResolverBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeBeanBuildItem;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class JpaProcessor {
    private static final String FEATURE = "camel-jpa";

    JpaProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureJpaComponentBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<CamelRuntimeBeanBuildItem> camelRuntimeBean, CamelJpaRecorder recorder) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{CamelJpaProducer.class}));
        camelRuntimeBean.produce((BuildItem)new CamelRuntimeBeanBuildItem("jpa", JpaComponent.class.getName(), recorder.createJpaComponent()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void registerPersistenceUnitCamelBeanQualifierResolver(List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<CamelBeanQualifierResolverBuildItem> camelBeanQualifierResolver, CamelJpaRecorder recorder) {
        PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor;
        if (persistenceUnitDescriptors.size() == 1 && !(persistenceUnitDescriptor = persistenceUnitDescriptors.get(0)).getPersistenceUnitName().equals("<default>")) {
            CamelBeanQualifierResolverBuildItem beanQualifierResolver = new CamelBeanQualifierResolverBuildItem(EntityManagerFactory.class, recorder.createPersistenceUnitQualifierResolver(persistenceUnitDescriptor.getPersistenceUnitName()));
            camelBeanQualifierResolver.produce((BuildItem)beanQualifierResolver);
        }
    }

    @BuildStep
    BytecodeTransformerBuildItem transformMethodJpaEndpointCreateEntityManagerFactory() {
        return new BytecodeTransformerBuildItem.Builder().setClassToTransform(JpaEndpoint.class.getName()).setCacheable(true).setVisitorFunction((className, classVisitor) -> new ClassVisitor(589824, (ClassVisitor)classVisitor){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                final MethodVisitor visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                if (name.equals("createEntityManagerFactory") && descriptor.equals("()Ljakarta/persistence/EntityManagerFactory;")) {
                    return new MethodVisitor(589824, visitor){

                        public void visitCode() {
                            super.visitCode();
                            visitor.visitTypeInsn(187, "java/lang/IllegalStateException");
                            visitor.visitInsn(89);
                            visitor.visitLdcInsn((Object)"Cannot create EntityManagerFactory. Check quarkus.hibernate-orm configuration.");
                            visitor.visitMethodInsn(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V", false);
                            visitor.visitInsn(191);
                        }
                    };
                }
                return visitor;
            }
        }).build();
    }
}

