/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.dsl.js.runtime;

import java.util.function.BiPredicate;
import org.apache.camel.quarkus.dsl.js.runtime.JavaScriptDslHelper;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public final class JavaScriptDslBiPredicate<T, U>
implements BiPredicate<T, U> {
    private final String firstArgumentName;
    private final String secondArgumentName;
    private final CharSequence source;

    public JavaScriptDslBiPredicate(CharSequence source) {
        this("t", "u", source);
    }

    public JavaScriptDslBiPredicate(String firstArgumentName, String secondArgumentName, CharSequence source) {
        this.firstArgumentName = firstArgumentName;
        this.secondArgumentName = secondArgumentName;
        this.source = source;
    }

    @Override
    public boolean test(T t, U u) {
        try (Context context = JavaScriptDslHelper.createBuilder().build();){
            Value bindings = context.getBindings("js");
            bindings.putMember(this.firstArgumentName, t);
            bindings.putMember(this.secondArgumentName, u);
            Value value = context.eval("js", this.source);
            boolean bl = value != null && value.asBoolean();
            return bl;
        }
    }
}

