/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.dsl.js.runtime;

import java.util.function.Predicate;
import org.apache.camel.quarkus.dsl.js.runtime.JavaScriptDslHelper;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public final class JavaScriptDslPredicate<T>
implements Predicate<T> {
    private final String argumentName;
    private final CharSequence source;

    public JavaScriptDslPredicate(CharSequence source) {
        this("t", source);
    }

    public JavaScriptDslPredicate(String argumentName, CharSequence source) {
        this.argumentName = argumentName;
        this.source = source;
    }

    @Override
    public boolean test(T t) {
        try (Context context = JavaScriptDslHelper.createBuilder().build();){
            Value bindings = context.getBindings("js");
            bindings.putMember(this.argumentName, t);
            Value value = context.eval("js", this.source);
            boolean bl = value != null && value.asBoolean();
            return bl;
        }
    }
}

