/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.path;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.IOException;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;
import net.minidev.json.reader.JsonWriter;
import net.minidev.json.reader.JsonWriterI;

@TargetClass(value=JSONValue.class)
final class JSONValueSubstitution {
    JSONValueSubstitution() {
    }

    @Substitute
    public static void writeJSONString(Object value, Appendable out, JSONStyle compression) throws IOException {
        if (value == null) {
            out.append("null");
            return;
        }
        Class<?> clz = value.getClass();
        JsonWriterI w = JSONValue.defaultWriter.getWrite(clz);
        if (w == null) {
            if (clz.isArray()) {
                w = JsonWriter.arrayWriter;
            } else {
                w = JSONValue.defaultWriter.getWriterByInterface(value.getClass());
                if (w == null) {
                    String format = "No suitable Jsonwriter found for class \"%s\", \"net.minidev.json.reader.BeansWriterASM\" is not supported in native mode.";
                    throw new UnsupportedOperationException(String.format(format, clz.getName()));
                }
            }
            JSONValue.defaultWriter.registerWriter(w, new Class[]{clz});
        }
        w.writeJSONString(value, out, compression);
    }
}

