/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kafka.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import java.util.List;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.quarkus.component.kafka.CamelKafkaRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeBeanBuildItem;
import org.apache.kafka.common.security.scram.internals.ScramSaslClient;

class KafkaProcessor {
    private static final String FEATURE = "camel-kafka";

    KafkaProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    CamelRuntimeBeanBuildItem createCamelKafkaComponent(CamelKafkaRecorder recorder, List<ServiceProviderBuildItem> serviceProviders) {
        return new CamelRuntimeBeanBuildItem("kafka", KafkaComponent.class.getName(), recorder.createKafkaComponent());
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{ScramSaslClient.ScramSaslClientFactory.class}));
    }
}

