/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kafka;

import io.quarkus.arc.DefaultBean;
import io.smallrye.common.annotation.Identifier;
import java.util.Map;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.quarkus.component.kafka.CamelKafkaRuntimeConfig;
import org.apache.camel.quarkus.component.kafka.QuarkusKafkaClientFactory;

@Singleton
public class KafkaClientFactoryProducer {
    @Inject
    @Identifier(value="default-kafka-broker")
    Map<String, Object> kafkaConfig;

    @Produces
    @Singleton
    @DefaultBean
    public KafkaClientFactory kafkaClientFactory(CamelKafkaRuntimeConfig config) {
        if (this.kafkaConfig != null && !this.kafkaConfig.isEmpty() && config.kubernetesServiceBinding.mergeConfiguration) {
            return new QuarkusKafkaClientFactory(this.kafkaConfig);
        }
        return null;
    }
}

