/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kafka;

import io.quarkus.arc.DefaultBean;
import io.smallrye.common.annotation.Identifier;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.quarkus.component.kafka.CamelKafkaRuntimeConfig;
import org.apache.camel.quarkus.component.kafka.QuarkusKafkaClientFactory;
import org.eclipse.microprofile.config.Config;

@Singleton
public class KafkaClientFactoryProducer {
    @Inject
    @Identifier(value="default-kafka-broker")
    Map<String, Object> kafkaConfig;
    @Inject
    CamelKafkaRuntimeConfig camelKafkaRuntimeConfig;
    @Inject
    Config config;

    @Produces
    @Singleton
    @DefaultBean
    public KafkaClientFactory kafkaClientFactory() {
        if (this.isQuarkusKafkaClientFactoryRequired()) {
            return new QuarkusKafkaClientFactory(this.kafkaConfig);
        }
        return null;
    }

    private boolean isQuarkusKafkaClientFactoryRequired() {
        Optional serviceBindingEnabled = this.config.getOptionalValue("quarkus.kubernetes-service-binding.enabled", Boolean.class);
        return this.kafkaConfig != null && !this.kafkaConfig.isEmpty() && this.camelKafkaRuntimeConfig.kubernetesServiceBinding.mergeConfiguration && serviceBindingEnabled.isPresent() && (Boolean)serviceBindingEnabled.get() != false;
    }
}

