/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kafka;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.component.kafka.DefaultKafkaClientFactory;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;

public class QuarkusKafkaClientFactory
extends DefaultKafkaClientFactory {
    private final Map<String, Object> quarkusKafkaConfiguration;

    public QuarkusKafkaClientFactory(Map<String, Object> quarkusKafkaConfiguration) {
        this.quarkusKafkaConfiguration = quarkusKafkaConfiguration;
    }

    public Producer getProducer(Properties camelKafkaProperties) {
        this.mergeConfiguration(camelKafkaProperties);
        return super.getProducer(camelKafkaProperties);
    }

    public Consumer getConsumer(Properties camelKafkaProperties) {
        this.mergeConfiguration(camelKafkaProperties);
        return super.getConsumer(camelKafkaProperties);
    }

    public String getBrokers(KafkaConfiguration configuration) {
        String brokers = (String)this.quarkusKafkaConfiguration.get("bootstrap.servers");
        return brokers != null ? brokers : super.getBrokers(configuration);
    }

    public void mergeConfiguration(Properties camelKafkaProperties) {
        if (this.quarkusKafkaConfiguration != null) {
            for (Map.Entry<String, Object> entry : this.quarkusKafkaConfiguration.entrySet()) {
                camelKafkaProperties.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

