/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kamelet.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Ordered;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.quarkus.component.kamelet.KameletConfiguration;
import org.apache.camel.quarkus.component.kamelet.KameletRecorder;
import org.apache.camel.quarkus.component.kamelet.deployment.KameletResolver;
import org.apache.camel.quarkus.component.kamelet.deployment.KameletResolverBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextCustomizerBuildItem;
import org.apache.camel.spi.Resource;

class KameletProcessor {
    private static final String FEATURE = "camel-kamelet";

    KameletProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    KameletResolverBuildItem defaultResolver() {
        return new KameletResolverBuildItem(new KameletResolver(){

            @Override
            public Optional<Resource> resolve(String id, CamelContext context) throws Exception {
                ExtendedCamelContext ecc = (ExtendedCamelContext)context.adapt(ExtendedCamelContext.class);
                return Optional.ofNullable(ecc.getResourceLoader().resolveResource("/kamelets/" + id + ".kamelet.yaml"));
            }
        });
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelContextCustomizerBuildItem configureTemplates(List<KameletResolverBuildItem> resolvers, KameletConfiguration configuration, KameletRecorder recorder) throws Exception {
        ArrayList<RouteTemplateDefinition> definitions = new ArrayList<RouteTemplateDefinition>();
        List kameletResolvers = resolvers.stream().map(KameletResolverBuildItem::getResolver).sorted(Comparator.comparingInt(Ordered::getOrder)).collect(Collectors.toList());
        DefaultCamelContext context = new DefaultCamelContext();
        ExtendedCamelContext ecc = (ExtendedCamelContext)context.adapt(ExtendedCamelContext.class);
        for (String id : configuration.identifiers.orElse(Collections.emptyList())) {
            for (KameletResolver resolver : kameletResolvers) {
                Optional<Resource> resource = resolver.resolve(id, (CamelContext)ecc);
                if (!resource.isPresent()) continue;
                Collection rbs = ecc.getRoutesLoader().findRoutesBuilders(new Resource[]{resource.get()});
                for (RoutesBuilder rb : rbs) {
                    RouteBuilder routeBuilder = (RouteBuilder)rb;
                    routeBuilder.configure();
                    if (routeBuilder.getRouteTemplateCollection().getRouteTemplates().size() == 0) {
                        throw new IllegalStateException("No kamelet template was created for kamelet:" + id + ". It might be that the kamelet was malformed?");
                    }
                    if (routeBuilder.getRouteTemplateCollection().getRouteTemplates().size() > 1) {
                        throw new IllegalStateException("A kamelet is not supposed to create more than one route (kamelet:" + id + ",routes: " + routeBuilder.getRouteTemplateCollection().getRouteTemplates().size() + ")");
                    }
                    definitions.add((RouteTemplateDefinition)routeBuilder.getRouteTemplateCollection().getRouteTemplates().get(0));
                }
            }
        }
        return new CamelContextCustomizerBuildItem(recorder.createTemplateLoaderCustomizer(definitions));
    }
}

