/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kamelet.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Ordered;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.quarkus.component.kamelet.EmptyKameletResource;
import org.apache.camel.quarkus.component.kamelet.KameletConfiguration;
import org.apache.camel.quarkus.component.kamelet.KameletRecorder;
import org.apache.camel.quarkus.component.kamelet.deployment.KameletResolver;
import org.apache.camel.quarkus.component.kamelet.deployment.KameletResolverBuildItem;
import org.apache.camel.quarkus.component.kamelet.deployment.KameletResourceBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextCustomizerBuildItem;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;
import org.jboss.logging.Logger;

class KameletProcessor {
    private static final Logger LOGGER = Logger.getLogger(KameletProcessor.class);
    private static final String FEATURE = "camel-kamelet";

    KameletProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    KameletResolverBuildItem defaultResolver() {
        return new KameletResolverBuildItem(new KameletResolver(){

            @Override
            public Optional<Resource> resolve(String id, CamelContext context) throws Exception {
                return Optional.ofNullable(PluginHelper.getResourceLoader((CamelContext)context).resolveResource("/kamelets/" + id + ".kamelet.yaml"));
            }
        });
    }

    @BuildStep
    void loadResources(List<KameletResolverBuildItem> resolvers, KameletConfiguration configuration, BuildProducer<KameletResourceBuildItem> resources) throws Exception {
        List<KameletResolver> kameletResolvers = resolvers.stream().map(KameletResolverBuildItem::getResolver).sorted(Comparator.comparingInt(Ordered::getOrder)).toList();
        DefaultCamelContext context = new DefaultCamelContext();
        for (String id : configuration.identifiers.orElse(Collections.emptyList())) {
            for (KameletResolver resolver : kameletResolvers) {
                resolver.resolve(id, (CamelContext)context).map(r -> new KameletResourceBuildItem(id, (Resource)r)).ifPresent(arg_0 -> resources.produce(arg_0));
            }
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelContextCustomizerBuildItem configureTemplates(List<KameletResourceBuildItem> resources, KameletRecorder recorder) throws Exception {
        ArrayList<RouteTemplateDefinition> definitions = new ArrayList<RouteTemplateDefinition>();
        try (DefaultCamelContext context = new DefaultCamelContext();){
            ExtendedCamelContext ecc = context.getCamelContextExtension();
            for (KameletResourceBuildItem item : resources) {
                LOGGER.debugf("Loading kamelet from: %s)", (Object)item.getResource());
                Collection rbs = PluginHelper.getRoutesLoader((ExtendedCamelContext)ecc).findRoutesBuilders(new Resource[]{item.getResource()});
                for (RoutesBuilder rb : rbs) {
                    RouteBuilder routeBuilder = (RouteBuilder)rb;
                    routeBuilder.configure();
                    if (routeBuilder.getRouteTemplateCollection().getRouteTemplates().isEmpty()) {
                        throw new IllegalStateException("No kamelet template was created for kamelet:" + item.getId() + ". It might be that the kamelet was malformed?");
                    }
                    if (routeBuilder.getRouteTemplateCollection().getRouteTemplates().size() > 1) {
                        throw new IllegalStateException("A kamelet is not supposed to create more than one route (kamelet:" + item.getId() + ",routes: " + routeBuilder.getRouteTemplateCollection().getRouteTemplates().size() + ")");
                    }
                    definitions.add((RouteTemplateDefinition)routeBuilder.getRouteTemplateCollection().getRouteTemplates().get(0));
                }
            }
        }
        definitions.forEach(definition -> {
            Resource originalResource = definition.getResource();
            EmptyKameletResource resource = new EmptyKameletResource();
            resource.setScheme(originalResource.getScheme());
            resource.setLocation(originalResource.getLocation());
            resource.setExists(originalResource.exists());
            definition.setResource((Resource)resource);
            definition.setCamelContext(null);
            if (definition.getRoute() != null && definition.getRoute().getOutputs() != null) {
                definition.getRoute().getOutputs().forEach(o -> o.setCamelContext(null));
            }
        });
        return new CamelContextCustomizerBuildItem(recorder.createTemplateLoaderCustomizer(definitions));
    }
}

