/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kamelet.deployment;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.quarkus.component.kamelet.KameletConfiguration;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

class KameletProcessor {
    private static final Logger LOGGER = Logger.getLogger(KameletProcessor.class);
    private static final String CLASS_PREFIX = "#class:";
    private static final String CLASSPATH_PREFIX = "classpath";
    private static final String FILE_PREFIX = "file";
    private static final String KAMELET_FILE_EXTENSION = ".kamelet.yaml";
    private static final String FEATURE = "camel-kamelet";

    KameletProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void kameletNativeModeSupport(CurateOutcomeBuildItem curateOutcome, BuildProducer<NativeImageResourcePatternsBuildItem> nativeImagePatterns, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, KameletConfiguration kameletConfig) {
        Set<String> kameletBeanClasses;
        List<String> kameletLocations = ConfigProvider.getConfig().getOptionalValues("camel.component.kamelet.location", String.class).orElse(List.of("classpath:kamelets"));
        final Set<String> identifiers = kameletConfig.identifiers().stream().map(String::trim).map(identifier -> identifier.replace(KAMELET_FILE_EXTENSION, "")).map(identifier -> identifier + KAMELET_FILE_EXTENSION).collect(Collectors.toUnmodifiableSet());
        final ArrayList<String> kameletResources = new ArrayList<String>();
        HashSet kameletClasspathPatterns = new HashSet();
        for (String kameletLocation : kameletLocations) {
            boolean isDefaultIdentifier;
            String scheme = StringHelper.before((String)kameletLocation, (String)":");
            String location = StringHelper.after((String)kameletLocation, (String)":", (String)kameletLocation);
            if (ObjectHelper.isEmpty((String)scheme) || scheme.equals(CLASSPATH_PREFIX)) {
                identifiers.forEach(identifier -> kameletClasspathPatterns.add(FileUtil.stripLeadingSeparator((String)location) + "/" + identifier));
                continue;
            }
            if (!scheme.equals(FILE_PREFIX)) continue;
            boolean bl = isDefaultIdentifier = identifiers.size() == 1 && identifiers.contains("*..kamelet.yaml");
            Path kameletsDir = Paths.get(location, new String[0]);
            if (!Files.isDirectory(kameletsDir, new LinkOption[0])) continue;
            try {
                Files.walkFileTree(kameletsDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (Files.isReadable(file)) {
                            String fileName = file.getFileName().toString();
                            if (isDefaultIdentifier && fileName.endsWith(KameletProcessor.KAMELET_FILE_EXTENSION) || identifiers.contains(fileName)) {
                                kameletResources.add("file:" + String.valueOf(file.toAbsolutePath()));
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException e) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.debugf((Throwable)e, "Failed to walk kamelet directory %s", (Object)location);
            }
        }
        if (!kameletClasspathPatterns.isEmpty()) {
            nativeImagePatterns.produce((BuildItem)NativeImageResourcePatternsBuildItem.builder().includeGlobs(kameletClasspathPatterns).build());
            PathFilter pathFilter = PathFilter.forIncludes(kameletClasspathPatterns);
            PathVisitor pathVisitor = visit -> kameletResources.add("classpath:" + this.sanitizePath(visit.getPath()));
            ApplicationModel applicationModel = curateOutcome.getApplicationModel();
            ResolvedDependency appArtifact = applicationModel.getAppArtifact();
            appArtifact.getContentTree(pathFilter).walk(pathVisitor);
            for (ResolvedDependency dependency : applicationModel.getRuntimeDependencies()) {
                dependency.getContentTree(pathFilter).walk(pathVisitor);
            }
        }
        if (!kameletResources.isEmpty() && !(kameletBeanClasses = this.resolveKameletBeanClasses(kameletResources)).isEmpty()) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])kameletBeanClasses.toArray(new String[0])).fields().methods().build());
        }
    }

    private Set<String> resolveKameletBeanClasses(List<String> kameletResources) {
        HashSet<String> kameletBeanClasses = new HashSet<String>();
        for (String kameletResource : kameletResources) {
            LOGGER.debugf("Processing kamelet resource %s", (Object)kameletResource);
            try {
                InputStream stream = this.getKameletAsStream(kameletResource);
                try {
                    if (stream == null) continue;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String beanClass;
                            if (line.startsWith("#") || !ObjectHelper.isNotEmpty((String)(beanClass = StringHelper.after((String)line, (String)CLASS_PREFIX)))) continue;
                            if ((beanClass = StringHelper.removeQuotes((String)beanClass)).contains("(")) {
                                beanClass = StringHelper.before((String)beanClass, (String)"(");
                            }
                            if (beanClass.contains("{{")) continue;
                            LOGGER.debugf("Discovered kamelet bean class %s", (Object)beanClass);
                            kameletBeanClasses.add(beanClass);
                        }
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                LOGGER.debugf((Throwable)e, "Failed processing kamelet resource %s", (Object)kameletResource);
            }
        }
        return kameletBeanClasses;
    }

    private InputStream getKameletAsStream(String kameletResource) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String scheme = StringHelper.before((String)kameletResource, (String)":");
        String location = StringHelper.after((String)kameletResource, (String)":", (String)kameletResource);
        if (ObjectHelper.isEmpty((String)scheme) || scheme.equals(CLASSPATH_PREFIX)) {
            return classLoader.getResourceAsStream(location);
        }
        if (scheme.equals(FILE_PREFIX)) {
            return Files.newInputStream(Paths.get(location, new String[0]), new OpenOption[0]);
        }
        return null;
    }

    private String sanitizePath(Path path) {
        String normalizedPath = FileUtil.normalizePath((String)path.toString());
        return FileUtil.stripLeadingSeparator((String)normalizedPath);
    }
}

