/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kamelet;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.annotations.RelaxedValidation;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.quarkus.component.kamelet.EmptyKameletResource;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;
import org.jboss.logging.Logger;

@Recorder
public class KameletRecorder {
    private static final Logger LOG = Logger.getLogger(KameletRecorder.class);

    public RuntimeValue<CamelContextCustomizer> createTemplateLoaderCustomizer(final @RelaxedValidation List<RouteTemplateDefinition> definitions) {
        return new RuntimeValue((Object)new CamelContextCustomizer(){

            public void configure(CamelContext context) {
                try {
                    ResourceLoader resourceLoader = PluginHelper.getResourceLoader((CamelContext)context);
                    for (RouteTemplateDefinition definition : definitions) {
                        Resource originalResource = definition.getResource();
                        String location = originalResource.getLocation();
                        if (originalResource instanceof EmptyKameletResource && !ObjectHelper.isNotEmpty((String)location)) {
                            Resource resource = resourceLoader.resolveResource(location);
                            if (resource != null) {
                                definition.setResource(resource);
                            } else if (LOG.isDebugEnabled()) {
                                LOG.debugf("Failed resolving Kamelet resource %s. Resource dumping will be disabled.", (Object)definition.getId());
                            }
                        }
                        definition.setCamelContext(context);
                        if (definition.getRoute() == null || definition.getRoute().getOutputs() == null) continue;
                        definition.getRoute().getOutputs().forEach(o -> o.setCamelContext(context));
                    }
                    ((Model)context.getCamelContextExtension().getContextPlugin(Model.class)).addRouteTemplateDefinitions((Collection)definitions);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

