/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.knative.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.VertxWebRouterBuildItem;
import java.util.List;
import org.apache.camel.component.knative.KnativeComponent;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.quarkus.component.knative.KnativeConsumerRecorder;
import org.apache.camel.quarkus.component.knative.KnativeProducerRecorder;
import org.apache.camel.quarkus.component.knative.KnativeRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceFilter;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceFilterBuildItem;
import org.apache.camel.spi.ComponentCustomizer;

class KnativeProcessor {
    private static final String FEATURE = "camel-knative";

    KnativeProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    List<UnremovableBeanBuildItem> unremovableBeans() {
        return List.of(UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{KnativeEnvironment.class}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> reflectiveClasses() {
        return List.of(new ReflectiveClassBuildItem(true, false, new Class[]{KnativeEnvironment.class}), new ReflectiveClassBuildItem(true, false, new Class[]{KnativeResource.class}));
    }

    @BuildStep
    List<CamelServiceFilterBuildItem> servicesFilters() {
        return List.of(new CamelServiceFilterBuildItem(CamelServiceFilter.forComponent((String)"knative")), new CamelServiceFilterBuildItem(CamelServiceFilter.forPathEndingWith((String)"META-INF/services/org/apache/camel/knative/transport/http")));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    CamelRuntimeBeanBuildItem knativeComponent(KnativeRecorder recorder) {
        return new CamelRuntimeBeanBuildItem("knative", KnativeComponent.class.getName(), recorder.createKnativeComponent());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    CamelRuntimeBeanBuildItem knativeConsumerCustomizer(KnativeConsumerRecorder recorder, VertxWebRouterBuildItem router) {
        return new CamelRuntimeBeanBuildItem("camel-knative-consumer-customizer", ComponentCustomizer.class.getName(), recorder.createKnativeConsumerFactoryCustomizer(router.getHttpRouter()));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    CamelRuntimeBeanBuildItem knativeProducerCustomizer(KnativeProducerRecorder recorder, CoreVertxBuildItem vertx) {
        return new CamelRuntimeBeanBuildItem("camel-knative-producer-customizer", ComponentCustomizer.class.getName(), recorder.createKnativeProducerFactoryCustomizer(vertx.getVertx()));
    }
}

