/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CamelMainHotDeploymentProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelMainHotDeploymentProcessor.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FILE_PREFIX = "file:";

    CamelMainHotDeploymentProcessor() {
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> xmlRoutes() {
        return CamelMainHotDeploymentProcessor.locations("camel.main.xml-routes");
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> xmlRests() {
        return CamelMainHotDeploymentProcessor.locations("camel.main.xml-rests");
    }

    private static List<HotDeploymentWatchedFileBuildItem> locations(String property) {
        String[] locations = (String[])CamelSupport.getOptionalConfigValue((String)property, String[].class, (Object)EMPTY_STRING_ARRAY);
        List<HotDeploymentWatchedFileBuildItem> items = Stream.of(locations).filter(location -> location.startsWith(FILE_PREFIX)).map(location -> location.substring(FILE_PREFIX.length())).distinct().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toAbsolutePath).map(Path::toString).map(HotDeploymentWatchedFileBuildItem::new).collect(Collectors.toList());
        if (!items.isEmpty()) {
            LOGGER.info("HotDeployment files ({}):", (Object)property);
            for (HotDeploymentWatchedFileBuildItem item : items) {
                LOGGER.info("- {}", (Object)item.getLocation());
            }
        }
        return items;
    }
}

