/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.apache.camel.main.Resilience4jConfigurationProperties;
import org.apache.camel.model.Resilience4jConfigurationCommon;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.apache.camel.quarkus.main.CamelMainApplication;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.AntPathMatcher;
import org.jboss.logging.Logger;

public class CamelMainNativeImageProcessor {
    private static final Logger LOG = Logger.getLogger(CamelMainNativeImageProcessor.class);

    @BuildStep
    ReflectiveClassBuildItem reflectiveCLasses() {
        return new ReflectiveClassBuildItem(true, false, new Class[]{Resilience4jConfigurationProperties.class, Resilience4jConfigurationDefinition.class, Resilience4jConfigurationCommon.class, RestConfiguration.class, CamelMainApplication.class});
    }

    @BuildStep
    void camelNativeImageResources(Capabilities capabilities, BuildProducer<NativeImageResourceBuildItem> nativeResource) {
        if (capabilities.isCapabilityPresent("org.apache.camel.xml")) {
            String[] properties;
            String prefix = "camel.main.";
            for (String property : properties = new String[]{"xml-rests", "xml-routes", "xml-route-templates"}) {
                this.embedCamelResource(prefix + property, nativeResource);
            }
        }
    }

    private void embedCamelResource(String propertyName, BuildProducer<NativeImageResourceBuildItem> nativeResource) {
        for (String path : (String[])CamelSupport.getOptionalConfigValue((String)propertyName, String[].class, (Object)new String[0])) {
            String scheme = ResourceHelper.getScheme((String)path);
            if (scheme != null && !scheme.equals("classpath:")) continue;
            if (AntPathMatcher.INSTANCE.isPattern(path)) {
                LOG.warnf("%s classpath wildcards does not work in native mode. Resources matching %s will not be loaded.", (Object)propertyName, (Object)path);
                continue;
            }
            nativeResource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path.replace("classpath:", "")}));
        }
    }
}

