/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Overridable;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.QuarkusMain;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.quarkus.core.CamelConfig;
import org.apache.camel.quarkus.core.CamelRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelRoutesBuilderClassBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelRoutesLoaderBuildItems;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeTaskBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.ContainerBeansBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.RuntimeCamelContextCustomizerBuildItem;
import org.apache.camel.quarkus.main.CamelMain;
import org.apache.camel.quarkus.main.CamelMainApplication;
import org.apache.camel.quarkus.main.CamelMainConfig;
import org.apache.camel.quarkus.main.CamelMainProducers;
import org.apache.camel.quarkus.main.CamelMainRecorder;
import org.apache.camel.quarkus.main.deployment.spi.CamelMainBuildItem;
import org.apache.camel.quarkus.main.deployment.spi.CamelMainListenerBuildItem;
import org.apache.camel.quarkus.main.deployment.spi.CamelRoutesCollectorBuildItem;
import org.jboss.jandex.DotName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelMainProcessor {
    private static Logger LOGGER = LoggerFactory.getLogger(CamelMainProcessor.class);

    @BuildStep
    void unremovableBeans(BuildProducer<AdditionalBeanBuildItem> beanProducer) {
        beanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(CamelMainProducers.class));
    }

    @Overridable
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    public CamelRoutesLoaderBuildItems.Registry routesLoader(CamelConfig config, CamelRecorder recorder) {
        return config.routesDiscovery.enabled ? new CamelRoutesLoaderBuildItems.Registry(recorder.newDefaultRegistryRoutesLoader()) : new CamelRoutesLoaderBuildItems.Registry(recorder.newDisabledRegistryRoutesLoader());
    }

    @Overridable
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    public CamelRoutesCollectorBuildItem routesCollector(CamelMainRecorder recorder, CamelRoutesLoaderBuildItems.Registry registryRoutesLoader) {
        return new CamelRoutesCollectorBuildItem((RuntimeValue<RoutesCollector>)recorder.newRoutesCollector(registryRoutesLoader.getLoader()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelMainBuildItem main(BeanContainerBuildItem beanContainer, ContainerBeansBuildItem containerBeans, CamelMainRecorder recorder, CamelContextBuildItem context, CamelRoutesCollectorBuildItem routesCollector, List<CamelRoutesBuilderClassBuildItem> routesBuilderClasses, List<CamelMainListenerBuildItem> listeners) {
        RuntimeValue main = recorder.createCamelMain(context.getCamelContext(), routesCollector.getValue(), beanContainer.getValue());
        for (CamelRoutesBuilderClassBuildItem item : routesBuilderClasses) {
            if (containerBeans.getClasses().contains(item.getDotName())) continue;
            recorder.addRoutesBuilder(main, item.getDotName().toString());
        }
        for (CamelMainListenerBuildItem listener : listeners) {
            recorder.addListener(main, listener.getListener());
        }
        return new CamelMainBuildItem((RuntimeValue<CamelMain>)main);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT, optional=true)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    CamelRuntimeBuildItem runtime(CombinedIndexBuildItem index, BeanContainerBuildItem beanContainer, CamelMainRecorder recorder, CamelMainBuildItem main, List<RuntimeCamelContextCustomizerBuildItem> customizers, List<CamelRuntimeTaskBuildItem> runtimeTasks, CamelMainConfig camelMainConfig) {
        recorder.customizeContext(main.getInstance(), customizers.stream().map(RuntimeCamelContextCustomizerBuildItem::get).collect(Collectors.toList()));
        return new CamelRuntimeBuildItem(recorder.createRuntime(beanContainer.getValue(), main.getInstance(), camelMainConfig.shutdown.timeout.toMillis()), index.getIndex().getAnnotations(DotName.createSimple((String)QuarkusMain.class.getName())).isEmpty());
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem indexCamelMainApplication() {
        return new AdditionalIndexedClassesBuildItem(new String[]{CamelMainApplication.class.getName()});
    }
}

