/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.management.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.lang.reflect.Modifier;
import java.rmi.NotBoundException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.MBeanException;
import javax.management.MBeanServerNotification;
import javax.management.ObjectInstance;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedNotification;
import org.apache.camel.api.management.ManagedNotifications;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.quarkus.component.management.CamelManagementRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelSerializationBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.RuntimeCamelContextCustomizerBuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class ManagementProcessor {
    private static final String FEATURE = "camel-management";
    private static final Class<?>[] CAMEL_MANAGEMENT_ANNOTATIONS = new Class[]{ManagedAttribute.class, ManagedNotification.class, ManagedNotifications.class, ManagedOperation.class, ManagedResource.class};
    private static final String[] SERIALIZATION_CLASSES = new String[]{DescriptorSupport.class.getName(), ModelMBeanAttributeInfo.class.getName(), ModelMBeanInfoSupport.class.getName(), ModelMBeanOperationInfo.class.getName(), MBeanException.class.getName(), MBeanServerNotification.class.getName(), NotBoundException.class.getName(), Object.class.getName(), ObjectInstance.class.getName()};

    ManagementProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void camelManagementMBeanSupport(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageProxyDefinitionBuildItem> nativeImageProxy, BuildProducer<CamelSerializationBuildItem> camelSerialization) {
        IndexView index = combinedIndex.getIndex();
        Set<String> managedBeanInterfaces = this.getManagedTypes(index, classInfo -> Modifier.isInterface(classInfo.flags()));
        managedBeanInterfaces.stream().map(xva$0 -> new NativeImageProxyDefinitionBuildItem(new String[]{xva$0})).forEach(arg_0 -> nativeImageProxy.produce(arg_0));
        Set managedBeanClasses = managedBeanInterfaces.stream().map(DotName::createSimple).flatMap(dotName -> index.getAllKnownImplementors(dotName).stream()).map(classInfo -> classInfo.name().toString()).collect(Collectors.toSet());
        managedBeanClasses.addAll(this.getManagedTypes(index, classInfo -> !Modifier.isInterface(classInfo.flags())));
        managedBeanClasses.add(RequiredModelMBean.class.getName());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])managedBeanClasses.toArray(String[]::new))).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])SERIALIZATION_CLASSES).serialization().build());
        camelSerialization.produce((BuildItem)new CamelSerializationBuildItem());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    RuntimeCamelContextCustomizerBuildItem configureCamelContext(CamelManagementRecorder recorder) {
        return new RuntimeCamelContextCustomizerBuildItem(recorder.createContextCustomizer());
    }

    private Set<String> getManagedTypes(IndexView index, Predicate<ClassInfo> typeFilter) {
        return Stream.of(CAMEL_MANAGEMENT_ANNOTATIONS).flatMap(annotation -> index.getAnnotations(annotation).stream()).map(AnnotationInstance::target).map(annotationTarget -> {
            AnnotationTarget.Kind kind = annotationTarget.kind();
            if (kind.equals((Object)AnnotationTarget.Kind.CLASS)) {
                return annotationTarget.asClass();
            }
            if (kind.equals((Object)AnnotationTarget.Kind.FIELD)) {
                return annotationTarget.asField().declaringClass();
            }
            if (kind.equals((Object)AnnotationTarget.Kind.METHOD)) {
                return annotationTarget.asMethod().declaringClass();
            }
            return null;
        }).filter(Objects::nonNull).filter(typeFilter).map(classInfo -> classInfo.name().toString()).collect(Collectors.toSet());
    }
}

