/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.micrometer.deployment;

import io.micrometer.core.instrument.MeterRegistry;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.micrometer.deployment.MicrometerProcessor;
import io.quarkus.micrometer.deployment.RootMeterRegistryBuildItem;
import org.apache.camel.quarkus.component.micrometer.CamelMicrometerConfig;
import org.apache.camel.quarkus.component.micrometer.CamelMicrometerRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextCustomizerBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.RuntimeCamelContextCustomizerBuildItem;

class MicrometerProcessor {
    private static final String FEATURE = "camel-micrometer";

    MicrometerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={MicrometerProcessor.MicrometerEnabled.class})
    CamelBeanBuildItem meterRegistry(RootMeterRegistryBuildItem registry) {
        return new CamelBeanBuildItem("metricsRegistry", MeterRegistry.class.getName(), registry.getValue());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={MicrometerProcessor.MicrometerEnabled.class})
    CamelContextCustomizerBuildItem contextCustomizer(CamelMicrometerRecorder recorder, CamelMicrometerConfig config) {
        return new CamelContextCustomizerBuildItem(recorder.createContextCustomizer(config));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={MicrometerProcessor.MicrometerEnabled.class})
    RuntimeCamelContextCustomizerBuildItem runtimeContextCustomizer(CamelMicrometerRecorder recorder, CamelMicrometerConfig config) {
        return new RuntimeCamelContextCustomizerBuildItem(recorder.createRuntimeContextCustomizer(config));
    }
}

