/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.micrometer;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import org.apache.camel.CamelContext;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifier;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryFactory;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyFactory;
import org.apache.camel.quarkus.component.micrometer.CamelMicrometerConfig;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RoutePolicyFactory;

@Recorder
public class CamelMicrometerRecorder {
    public RuntimeValue<CamelContextCustomizer> createContextCustomizer(CamelMicrometerConfig config) {
        return new RuntimeValue((Object)new MicrometerContextCustomizer(config));
    }

    public RuntimeValue<CamelContextCustomizer> createRuntimeContextCustomizer(CamelMicrometerConfig config) {
        return new RuntimeValue((Object)new MicrometerRuntimeContextCustomizer(config));
    }

    private static class MicrometerRuntimeContextCustomizer
    implements CamelContextCustomizer {
        private final CamelMicrometerConfig config;

        public MicrometerRuntimeContextCustomizer(CamelMicrometerConfig config) {
            this.config = config;
        }

        public void configure(CamelContext camelContext) {
            if (!this.config.enableMessageHistory) {
                return;
            }
            if (!camelContext.isMessageHistory().booleanValue()) {
                camelContext.setMessageHistory(Boolean.valueOf(true));
            }
            camelContext.setMessageHistoryFactory((MessageHistoryFactory)new MicrometerMessageHistoryFactory());
        }
    }

    private static class MicrometerContextCustomizer
    implements CamelContextCustomizer {
        private final CamelMicrometerConfig config;

        public MicrometerContextCustomizer(CamelMicrometerConfig config) {
            this.config = config;
        }

        public void configure(CamelContext camelContext) {
            if (this.config.enableRoutePolicy) {
                camelContext.addRoutePolicyFactory((RoutePolicyFactory)new MicrometerRoutePolicyFactory());
            }
            ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
            if (this.config.enableExchangeEventNotifier) {
                managementStrategy.addEventNotifier((EventNotifier)new MicrometerExchangeEventNotifier());
            }
            if (this.config.enableRouteEventNotifier) {
                managementStrategy.addEventNotifier((EventNotifier)new MicrometerRouteEventNotifier());
            }
        }
    }
}

