/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.health.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.DefaultHealthCheckRegistry;
import org.apache.camel.microprofile.health.AbstractCamelMicroProfileHealthCheck;
import org.apache.camel.quarkus.component.microprofile.health.runtime.CamelMicroProfileHealthConfig;
import org.apache.camel.quarkus.component.microprofile.health.runtime.CamelMicroProfileHealthRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class MicroProfileHealthProcessor {
    private static final DotName CAMEL_HEALTH_CHECK_REGISTRY_DOTNAME = DotName.createSimple((String)HealthCheckRegistry.class.getName());
    private static final DotName CAMEL_HEALTH_CHECK_DOTNAME = DotName.createSimple((String)HealthCheck.class.getName());
    private static final DotName CAMEL_HEALTH_CHECK_REPOSITORY_DOTNAME = DotName.createSimple((String)HealthCheckRepository.class.getName());
    private static final DotName MICROPROFILE_LIVENESS_DOTNAME = DotName.createSimple((String)Liveness.class.getName());
    private static final DotName MICROPROFILE_READINESS_DOTNAME = DotName.createSimple((String)Readiness.class.getName());
    private static final DotName VETOED_DOTNAME = DotName.createSimple((String)Vetoed.class.getName());
    private static final String FEATURE = "camel-microprofile-health";

    MicroProfileHealthProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem metricRegistry(CamelMicroProfileHealthRecorder recorder, CamelMicroProfileHealthConfig config) {
        return new CamelBeanBuildItem("HealthCheckRegistry", HealthCheckRegistry.class.getName(), recorder.createHealthCheckRegistry(config));
    }

    @BuildStep
    List<CamelBeanBuildItem> camelHealthDiscovery(CombinedIndexBuildItem combinedIndex, CamelMicroProfileHealthConfig config) {
        ArrayList<CamelBeanBuildItem> buildItems = new ArrayList<CamelBeanBuildItem>();
        if (config.enabled) {
            IndexView index = combinedIndex.getIndex();
            Collection healthChecks = index.getAllKnownImplementors(CAMEL_HEALTH_CHECK_DOTNAME);
            Collection healthCheckRepositories = index.getAllKnownImplementors(CAMEL_HEALTH_CHECK_REPOSITORY_DOTNAME);
            healthChecks.stream().filter(CamelSupport::isConcrete).filter(CamelSupport::isPublic).filter(ClassInfo::hasNoArgsConstructor).map(classInfo -> new CamelBeanBuildItem(classInfo.simpleName(), classInfo.name().toString())).forEach(buildItems::add);
            healthCheckRepositories.stream().filter(CamelSupport::isConcrete).filter(CamelSupport::isPublic).filter(ClassInfo::hasNoArgsConstructor).filter(classInfo -> !classInfo.simpleName().equals(DefaultHealthCheckRegistry.class.getSimpleName())).map(classInfo -> new CamelBeanBuildItem(classInfo.simpleName(), classInfo.name().toString())).forEach(buildItems::add);
        }
        return buildItems;
    }

    @BuildStep
    void disableCamelMicroProfileHealthChecks(BuildProducer<AnnotationsTransformerBuildItem> transformers, CamelMicroProfileHealthConfig config) {
        if (!config.enabled) {
            transformers.produce((BuildItem)new AnnotationsTransformerBuildItem(context -> {
                AnnotationTarget target;
                if (context.isClass() && this.isCamelMicroProfileHealthCheck((target = context.getTarget()).asClass())) {
                    AnnotationInstance annotationInstance = AnnotationInstance.create((DotName)VETOED_DOTNAME, (AnnotationTarget)target, (AnnotationValue[])new AnnotationValue[0]);
                    ((Transformation)context.transform().add(annotationInstance)).done();
                }
            }));
        }
    }

    private boolean isCamelMicroProfileHealthCheck(ClassInfo classInfo) {
        String className = classInfo.name().toString();
        return className.startsWith(AbstractCamelMicroProfileHealthCheck.class.getPackage().getName()) && (classInfo.classAnnotation(MICROPROFILE_LIVENESS_DOTNAME) != null || classInfo.classAnnotation(MICROPROFILE_READINESS_DOTNAME) != null);
    }
}

