/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.health.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.smallrye.health.deployment.SmallRyeHealthBuildTimeConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.ConsumersHealthCheckRepository;
import org.apache.camel.impl.health.HealthCheckRegistryRepository;
import org.apache.camel.impl.health.RoutesHealthCheckRepository;
import org.apache.camel.quarkus.component.microprofile.health.runtime.CamelMicroProfileHealthConfig;
import org.apache.camel.quarkus.component.microprofile.health.runtime.CamelMicroProfileHealthRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextCustomizerBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceDestination;
import org.apache.camel.quarkus.core.deployment.spi.CamelServicePatternBuildItem;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class MicroProfileHealthProcessor {
    private static final DotName CAMEL_HEALTH_CHECK_DOTNAME = DotName.createSimple((String)HealthCheck.class.getName());
    private static final DotName CAMEL_HEALTH_CHECK_REPOSITORY_DOTNAME = DotName.createSimple((String)HealthCheckRepository.class.getName());
    private static final String FEATURE = "camel-microprofile-health";

    MicroProfileHealthProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={HealthEnabled.class})
    CamelServicePatternBuildItem excludeDefaultHealthCheckRegistry() {
        return new CamelServicePatternBuildItem(CamelServiceDestination.DISCOVERY, false, new String[]{"META-INF/services/org/apache/camel/health-check/default-registry"});
    }

    @BuildStep(onlyIf={HealthEnabled.class, HealthRegistryEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    CamelContextCustomizerBuildItem customizeHealthCheckRegistry(CamelMicroProfileHealthRecorder recorder) {
        return new CamelContextCustomizerBuildItem(recorder.createHealthCheckRegistry());
    }

    @BuildStep(onlyIf={HealthEnabled.class})
    List<CamelBeanBuildItem> camelHealthDiscovery(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        ArrayList<CamelBeanBuildItem> buildItems = new ArrayList<CamelBeanBuildItem>();
        Collection healthChecks = index.getAllKnownImplementors(CAMEL_HEALTH_CHECK_DOTNAME);
        Collection healthCheckRepositories = index.getAllKnownImplementors(CAMEL_HEALTH_CHECK_REPOSITORY_DOTNAME);
        Config config = ConfigProvider.getConfig();
        Predicate<ClassInfo> healthCheckFilter = classInfo -> {
            String className = classInfo.name().toString();
            if (className.equals(HealthCheckRegistryRepository.class.getName())) {
                return false;
            }
            if (className.equals(RoutesHealthCheckRepository.class.getName())) {
                return config.getOptionalValue("camel.health.routesEnabled", Boolean.TYPE).orElse(true);
            }
            if (className.equals(ConsumersHealthCheckRepository.class.getName())) {
                return config.getOptionalValue("camel.health.consumersEnabled", Boolean.TYPE).orElse(true);
            }
            return true;
        };
        healthChecks.stream().filter(CamelSupport::isConcrete).filter(CamelSupport::isPublic).filter(ClassInfo::hasNoArgsConstructor).filter(healthCheckFilter).map(this::createHealthCamelBeanBuildItem).forEach(buildItems::add);
        healthCheckRepositories.stream().filter(CamelSupport::isConcrete).filter(CamelSupport::isPublic).filter(ClassInfo::hasNoArgsConstructor).filter(healthCheckFilter).map(this::createHealthCamelBeanBuildItem).forEach(buildItems::add);
        return buildItems;
    }

    private CamelBeanBuildItem createHealthCamelBeanBuildItem(ClassInfo classInfo) {
        String className = classInfo.name().toString();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String beanName;
            Class<?> clazz = classLoader.loadClass(className);
            Object health = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (health instanceof HealthCheck) {
                beanName = ((HealthCheck)health).getId();
            } else if (health instanceof HealthCheckRepository) {
                beanName = ((HealthCheckRepository)health).getId();
            } else {
                throw new IllegalArgumentException("Unknown health type " + className);
            }
            if (ObjectHelper.isEmpty((String)beanName)) {
                beanName = className;
            }
            return new CamelBeanBuildItem(beanName, className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final class HealthRegistryEnabled
    implements BooleanSupplier {
        HealthRegistryEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return ConfigProvider.getConfig().getOptionalValue("camel.health.registryEnabled", Boolean.TYPE).orElse(true);
        }
    }

    static final class HealthEnabled
    implements BooleanSupplier {
        CamelMicroProfileHealthConfig camelHealthConfig;
        SmallRyeHealthBuildTimeConfig quarkusHealthConfig;

        HealthEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            boolean mpHealthDisabled = ConfigProvider.getConfig().getOptionalValue("mp.health.disable-default-procedures", Boolean.TYPE).orElse(false);
            boolean camelHealthEnabled = ConfigProvider.getConfig().getOptionalValue("camel.health.enabled", Boolean.TYPE).orElse(true);
            return !mpHealthDisabled && camelHealthEnabled && this.camelHealthConfig.enabled() && this.quarkusHealthConfig.enabled();
        }
    }
}

