/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.metrics.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.metrics.MetricRegistries;
import org.apache.camel.CamelContext;
import org.apache.camel.component.microprofile.metrics.event.notifier.context.MicroProfileMetricsCamelContextEventNotifier;
import org.apache.camel.component.microprofile.metrics.event.notifier.exchange.MicroProfileMetricsExchangeEventNotifier;
import org.apache.camel.component.microprofile.metrics.event.notifier.route.MicroProfileMetricsRouteEventNotifier;
import org.apache.camel.component.microprofile.metrics.message.history.MicroProfileMetricsMessageHistoryFactory;
import org.apache.camel.component.microprofile.metrics.route.policy.MicroProfileMetricsRoutePolicyFactory;
import org.apache.camel.quarkus.component.microprofile.metrics.runtime.CamelMicroProfileMetricsConfig;
import org.apache.camel.quarkus.core.CamelContextCustomizer;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.logging.Logger;

@Recorder
public class CamelMicroProfileMetricsRecorder {
    public RuntimeValue<MetricRegistry> createApplicationRegistry() {
        return new RuntimeValue((Object)MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION));
    }

    public RuntimeValue<CamelContextCustomizer> createContextCustomizer(CamelMicroProfileMetricsConfig config) {
        return new RuntimeValue((Object)new MicroProfileMetricsContextCustomizer(config));
    }

    public RuntimeValue<CamelContextCustomizer> createRuntimeContextCustomizer(CamelMicroProfileMetricsConfig config) {
        return new RuntimeValue((Object)new MicroProfileMetricsRuntimeContextCustomizer(config));
    }

    private static class MicroProfileMetricsRuntimeContextCustomizer
    implements CamelContextCustomizer {
        private static final Logger LOGGER = Logger.getLogger(MicroProfileMetricsRuntimeContextCustomizer.class);
        private final CamelMicroProfileMetricsConfig config;

        public MicroProfileMetricsRuntimeContextCustomizer(CamelMicroProfileMetricsConfig config) {
            this.config = config;
        }

        public void customize(CamelContext camelContext) {
            if (!this.config.enableMessageHistory) {
                return;
            }
            if (!camelContext.isMessageHistory().booleanValue()) {
                LOGGER.warn((Object)"MessageHistory is not use and will be enabled as required by MicroProfile Metrics for MessageHistory");
                camelContext.setMessageHistory(Boolean.valueOf(true));
            }
            camelContext.setMessageHistoryFactory((MessageHistoryFactory)new MicroProfileMetricsMessageHistoryFactory());
        }
    }

    private static class MicroProfileMetricsContextCustomizer
    implements CamelContextCustomizer {
        private final CamelMicroProfileMetricsConfig config;

        public MicroProfileMetricsContextCustomizer(CamelMicroProfileMetricsConfig config) {
            this.config = config;
        }

        public void customize(CamelContext camelContext) {
            if (this.config.enableRoutePolicy) {
                camelContext.addRoutePolicyFactory((RoutePolicyFactory)new MicroProfileMetricsRoutePolicyFactory());
            }
            ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
            if (this.config.enableExchangeEventNotifier) {
                managementStrategy.addEventNotifier((EventNotifier)new MicroProfileMetricsExchangeEventNotifier());
            }
            if (this.config.enableRouteEventNotifier) {
                managementStrategy.addEventNotifier((EventNotifier)new MicroProfileMetricsRouteEventNotifier());
            }
            if (this.config.enableCamelContextEventNotifier) {
                managementStrategy.addEventNotifier((EventNotifier)new MicroProfileMetricsCamelContextEventNotifier());
            }
        }
    }
}

