/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty.http.runtime;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyWorkerPoolBuilder;
import org.apache.camel.util.concurrent.CamelThreadFactory;

@TargetClass(value=NettyWorkerPoolBuilder.class)
final class SubstituteNettyWorkerPoolBuilder {
    @Alias
    private String name = "NettyWorker";
    @Alias
    private String pattern;
    @Alias
    private int workerCount;
    @Alias
    private volatile EventLoopGroup workerPool;

    SubstituteNettyWorkerPoolBuilder() {
    }

    @Substitute
    public EventLoopGroup build() {
        int count = this.workerCount > 0 ? this.workerCount : NettyHelper.DEFAULT_IO_THREADS;
        this.workerPool = new NioEventLoopGroup(count, (ThreadFactory)new CamelThreadFactory(this.pattern, this.name, false));
        return this.workerPool;
    }
}

