/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openapi.java.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.quarkus.component.openapi.java.deployment.CamelRestOASFilter;
import org.apache.camel.quarkus.component.openapi.java.deployment.OpenApiJavaBuildTimeConfig;
import org.apache.camel.quarkus.core.deployment.main.CamelMainHelper;
import org.apache.camel.quarkus.core.deployment.spi.CamelRoutesBuilderClassBuildItem;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.eclipse.microprofile.openapi.OASFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenApiJavaProcessor {
    private static final String FEATURE = "camel-openapi-java";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiJavaProcessor.class);
    private static final Class<?>[] OPENAPI_ARRAY_TYPES = new Class[]{Integer.class, Long.class, Float.class, Double.class, Boolean.class};

    OpenApiJavaProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])OPENAPI_ARRAY_TYPES).methods().build());
    }

    @BuildStep(onlyIf={ExposeOpenApiEnabled.class})
    void exposeOpenAPI(List<CamelRoutesBuilderClassBuildItem> routesBuilderClasses, BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPI, Capabilities capabilities) throws Exception {
        if (capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            CamelContext ctx = CamelSupport.newBuildTimeCamelContext((boolean)true);
            RoutesConfigurer configurer = new RoutesConfigurer(ctx);
            ArrayList<RouteBuilder> routes = new ArrayList<RouteBuilder>();
            configurer.setRoutesBuilders(routes);
            configurer.setRoutesCollector((RoutesCollector)new DefaultRoutesCollector());
            configurer.setRoutesIncludePattern(CamelMainHelper.routesIncludePattern().collect(Collectors.joining(",")));
            configurer.setRoutesExcludePattern(CamelMainHelper.routesExcludePattern().collect(Collectors.joining(",")));
            if (!routesBuilderClasses.isEmpty()) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (!(loader instanceof QuarkusClassLoader)) {
                    throw new IllegalStateException(QuarkusClassLoader.class.getSimpleName() + " expected as the context class loader");
                }
                for (CamelRoutesBuilderClassBuildItem routesBuilderClass : routesBuilderClasses) {
                    String className = routesBuilderClass.getDotName().toString();
                    Class<?> cl = loader.loadClass(className);
                    if (!RouteBuilder.class.isAssignableFrom(cl)) continue;
                    try {
                        RouteBuilder rb = (RouteBuilder)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        routes.add(rb);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException("Could not instantiate " + className, e);
                    }
                }
            }
            try {
                configurer.configureRoutes(ctx);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to configure routes due to: {}.", (Object)e.getMessage(), (Object)e);
            }
            openAPI.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)new CamelRestOASFilter(ctx)));
        }
    }

    public static final class ExposeOpenApiEnabled
    implements BooleanSupplier {
        OpenApiJavaBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.expose().enabled();
        }
    }
}

