/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.quartz;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.quartz.QuartzScheduler;
import io.quarkus.quartz.runtime.QuartzSchedulerImpl;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.enterprise.inject.AmbiguousResolutionException;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.spi.annotations.Component;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Recorder
public class CamelQuartzRecorder {
    public RuntimeValue<QuartzComponent> createQuartzComponent() {
        return new RuntimeValue((Object)new QuarkusQuartzComponent());
    }

    @Component(value="quartz")
    static class QuarkusQuartzComponent
    extends QuartzComponent {
        private static final Logger LOG = LoggerFactory.getLogger(QuarkusQuartzComponent.class);

        QuarkusQuartzComponent() {
        }

        public boolean isAutowiredEnabled() {
            return false;
        }

        protected void doStartScheduler() throws Exception {
            if (super.isAutowiredEnabled() && this.getCamelContext().isAutowiredEnabled().booleanValue()) {
                InjectableInstance schedulers = Arc.container().select(Scheduler.class, new Annotation[0]);
                LinkedList<Scheduler> foundSchedulers = new LinkedList<Scheduler>();
                for (InstanceHandle handle : schedulers.handles()) {
                    if (handle.getBean().getBeanClass().equals(QuartzSchedulerImpl.class)) {
                        Scheduler scheduler = ((QuartzScheduler)Arc.container().select(QuartzScheduler.class, new Annotation[0]).getHandle().get()).getScheduler();
                        if (scheduler == null) continue;
                        foundSchedulers.add(scheduler);
                        continue;
                    }
                    foundSchedulers.add((Scheduler)handle.get());
                }
                if (foundSchedulers.size() > 1) {
                    throw new AmbiguousResolutionException(String.format("Found %d org.quartz.Scheduler beans (%s).", foundSchedulers.size(), foundSchedulers.stream().map(s -> {
                        try {
                            return s.getSchedulerName();
                        }
                        catch (SchedulerException e) {
                            return "Scheduler name retrieval failed.";
                        }
                    }).collect(Collectors.joining(", "))));
                }
                if (!foundSchedulers.isEmpty()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Autowired property: scheduler on component: quartz as exactly one instance of type: {} found in the registry", (Object)Scheduler.class.getName());
                    }
                    this.setScheduler((Scheduler)foundSchedulers.getFirst());
                }
            }
            super.doStartScheduler();
        }
    }
}

