/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.qute;

import io.quarkus.qute.Engine;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.qute.QuteEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;

@Component(value="qute")
public class QuteComponent
extends DefaultComponent {
    @Metadata(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @Metadata(label="advanced")
    private Engine quteEngine;

    public Engine getQuteEngine() {
        return this.quteEngine;
    }

    public void setQuteEngine(Engine quteEngine) {
        this.quteEngine = quteEngine;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        QuteEndpoint answer = new QuteEndpoint(uri, this, remaining);
        answer.setContentCache(cache);
        answer.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        answer.setQuteEngine(this.quteEngine);
        this.setProperties((Endpoint)answer, parameters);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }
}

