/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.Variant;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.qute.QuteComponent;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.2.0", scheme="qute", title="Qute", syntax="qute:resourceUri", producerOnly=true, label="transformation")
public class QuteEndpoint
extends ResourceEndpoint {
    private Engine quteEngine;
    @UriParam(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @UriParam
    private String encoding;

    public QuteEndpoint() {
    }

    public QuteEndpoint(String uri, QuteComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    protected String createEndpointUri() {
        return "qute:" + this.getResourceUri();
    }

    public void setQuteEngine(Engine engine) {
        this.quteEngine = engine;
    }

    private synchronized Engine getQuteEngine() {
        if (this.quteEngine == null) {
            EngineBuilder builder = Engine.builder().addDefaults();
            builder.addValueResolver(ReflectionValueResolver::new);
            builder.addLocator(this::locate);
            this.quteEngine = builder.build();
        }
        return this.quteEngine;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    private Optional<TemplateLocator.TemplateLocation> locate(final String path) {
        return Optional.of(new TemplateLocator.TemplateLocation(){

            private URL locatePath(String path2) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = QuteEndpoint.class.getClassLoader();
                }
                return cl.getResource(path2);
            }

            public Reader read() {
                try {
                    InputStream in = path.equals(QuteEndpoint.this.getResourceUri()) ? QuteEndpoint.this.getResourceAsInputStream() : this.locatePath(path).openStream();
                    InputStreamReader reader = QuteEndpoint.this.getEncoding() != null ? new InputStreamReader(in, QuteEndpoint.this.getEncoding()) : new InputStreamReader(in);
                    return reader;
                }
                catch (Exception e) {
                    QuteEndpoint.this.log.warn("Can not load template " + path + " due to " + e);
                    return null;
                }
            }

            public Optional<Variant> getVariant() {
                return Optional.empty();
            }
        });
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public QuteEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (QuteEndpoint)this.getCamelContext().getEndpoint(newUri, QuteEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        String newResourceUri;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        if (this.allowTemplateFromHeader && (newResourceUri = (String)exchange.getIn().getHeader("CamelQuteResourceUri", String.class)) != null) {
            exchange.getIn().removeHeader("CamelQuteResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelQuteResourceUri", (Object)newResourceUri);
            QuteEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        String content = null;
        if (this.allowTemplateFromHeader && (content = (String)exchange.getIn().getHeader("CamelQuteTemplate", String.class)) != null) {
            exchange.getIn().removeHeader("CamelQuteTemplate");
        }
        TemplateInstance instance = null;
        if (this.allowTemplateFromHeader) {
            instance = (TemplateInstance)exchange.getIn().getHeader("CamelQuteTemplateInstance", TemplateInstance.class);
        }
        if (instance != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Qute template instance is from header {} for endpoint {}", (Object)"CamelQuteTemplateInstance", (Object)this.getEndpointUri());
            }
            exchange.getIn().removeHeader("CamelQuteTemplateInstance");
        } else {
            Template template;
            Engine engine = this.getQuteEngine();
            if (content == null) {
                template = engine.getTemplate(path);
                if (template == null) {
                    throw new TemplateException("Unable to parse Qute template from path: " + path);
                }
            } else {
                template = engine.parse(content);
                if (template == null) {
                    throw new TemplateException("Unable to parse Qute template");
                }
            }
            instance = template.instance();
        }
        ExchangeHelper.createVariableMap((Exchange)exchange, (boolean)this.isAllowContextMapAll()).forEach((arg_0, arg_1) -> ((TemplateInstance)instance).data(arg_0, arg_1));
        Map map = (Map)exchange.getIn().getHeader("CamelQuteTemplateData", Map.class);
        if (map != null) {
            map.forEach((arg_0, arg_1) -> ((TemplateInstance)instance).data(arg_0, arg_1));
        }
        exchange.getMessage().setBody((Object)instance.render().trim());
    }
}

