/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.openapi.deployment;

import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.features.BeanValidationFeatures;
import io.swagger.codegen.v3.generators.features.NotNullAnnotationFeatures;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.java.AbstractJavaCodegen;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;

public class QuarkusCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
NotNullAnnotationFeatures {
    protected boolean useBeanValidation = false;
    private boolean notNullJacksonAnnotation = false;

    public QuarkusCodegen() {
        this.importMapping.put("QuarkusRegisterForReflection", "io.quarkus.runtime.annotations.RegisterForReflection");
        this.importMapping.put("JsonIgnoreProperties", "com.fasterxml.jackson.annotation.JsonIgnoreProperties");
        this.supportedLibraries.put("quarkus3", "Quarkus 3 framework");
    }

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return "quarkus";
    }

    public String getHelp() {
        return "Generate the models based on Quarkus framework";
    }

    public String getDefaultTemplateDir() {
        return "Quarkus";
    }

    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel model = super.fromModel(name, schema, allSchemas);
        if (schema != null && "array".equals(schema.getType())) {
            this.additionalProperties.put("useQuarkusRegisterForReflection", false);
        }
        if (this.additionalProperties.containsKey("ignoreUnknownProperties")) {
            model.imports.add("JsonIgnoreProperties");
        }
        return model;
    }

    public void processOpts() {
        if ("quarkus3".equals(this.library)) {
            this.dateLibrary = "java8";
            this.additionalProperties.put("jakarta", true);
            this.additionalProperties.put("jackson", "true");
        }
        super.processOpts();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBooleanAndWriteBack("useBeanValidation"));
        }
        String invokerFolder = (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator);
        if (this.additionalProperties.containsKey("jackson")) {
            this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", invokerFolder, "RFC3339DateFormat.java"));
        }
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)model, (String)"x-is-enum");
        if (!BooleanUtils.toBoolean((Boolean)isEnum)) {
            if (this.additionalProperties.containsKey("jackson")) {
                model.imports.add("JsonProperty");
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonValue");
            model.imports.add("JsonCreator");
        }
        model.imports.add("QuarkusRegisterForReflection");
        this.additionalProperties.put("useQuarkusRegisterForReflection", true);
        if (this.additionalProperties.containsKey("ignoreUnknownProperties")) {
            model.imports.add("JsonIgnoreProperties");
        }
    }

    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    public void setNotNullJacksonAnnotation(boolean notNullJacksonAnnotation) {
        this.notNullJacksonAnnotation = notNullJacksonAnnotation;
    }

    public boolean isNotNullJacksonAnnotation() {
        return this.notNullJacksonAnnotation;
    }
}

