/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.openapi.deployment;

import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.CodegenArgument;
import io.swagger.codegen.v3.DefaultGenerator;
import io.swagger.codegen.v3.config.CodegenConfigurator;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public class CamelQuarkusSwaggerCodegenProvider
implements CodeGenProvider {
    private static final Logger LOG = Logger.getLogger(CamelQuarkusSwaggerCodegenProvider.class);

    public String providerId() {
        return "camel-quarkus-rest-openapi";
    }

    public String[] inputExtensions() {
        return new String[]{"json", "yaml"};
    }

    public String inputDirectory() {
        return "openapi";
    }

    public boolean shouldRun(Path sourceDir, Config config) {
        return Files.isDirectory(sourceDir, new LinkOption[0]) || config.getOptionalValue("quarkus.camel.openapi.codegen.locations", String.class).isPresent();
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        Config config = context.config();
        if (!((Boolean)config.getValue("quarkus.camel.openapi.codegen.enabled", Boolean.class)).booleanValue()) {
            LOG.info((Object)("Skipping " + String.valueOf(this.getClass()) + " invocation on user's request"));
            return false;
        }
        try {
            Optional locations;
            HashSet<String> specFiles = new HashSet<String>();
            if (Files.isDirectory(context.inputDir(), new LinkOption[0])) {
                try (Stream<Path> protoFilesPaths = Files.walk(context.inputDir(), new FileVisitOption[0]);){
                    protoFilesPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(s -> s.toString().endsWith("json") || s.toString().endsWith("yaml")).map(Path::normalize).map(Path::toAbsolutePath).map(Path::toString).forEach(specFiles::add);
                }
            }
            if ((locations = config.getOptionalValue("quarkus.camel.openapi.codegen.locations", String.class)).isPresent()) {
                for (String location : ((String)locations.get()).split(",")) {
                    try {
                        URI uri = location.indexOf("://") == -1 ? Thread.currentThread().getContextClassLoader().getResource(location).toURI() : new URI(location);
                        Path path = Path.of(uri);
                        specFiles.add(path.toAbsolutePath().toString());
                    }
                    catch (Exception e) {
                        LOG.warnf((Throwable)e, "Can not find location %s", (Object)location);
                    }
                }
            }
            String packageName = (String)config.getValue("quarkus.camel.openapi.codegen.model-package", String.class);
            String models = config.getOptionalValue("quarkus.camel.openapi.codegen.models", String.class).orElse("");
            boolean useBeanValidation = (Boolean)config.getValue("quarkus.camel.openapi.codegen.use-bean-validation", Boolean.class);
            boolean notNullJackson = (Boolean)config.getValue("quarkus.camel.openapi.codegen.not-null-jackson", Boolean.class);
            boolean ignoreUnknownProperties = (Boolean)config.getValue("quarkus.camel.openapi.codegen.ignore-unknown-properties", Boolean.class);
            for (String specFile : specFiles) {
                LOG.infof("Generating models for %s", (Object)specFile);
                CodegenConfigurator configurator = new CodegenConfigurator();
                configurator.setLang("quarkus");
                configurator.setLibrary("quarkus3");
                configurator.setModelPackage(packageName);
                configurator.setInputSpecURL(specFile);
                configurator.setOutputDir(context.outDir().toAbsolutePath().toString());
                System.setProperty("models", models);
                configurator.getCodegenArguments().add(new CodegenArgument().option("--api-docs").type("boolean").value("false"));
                configurator.getCodegenArguments().add(new CodegenArgument().option("--model-docs").type("boolean").value("false"));
                if (useBeanValidation) {
                    configurator.getAdditionalProperties().put("useBeanValidation", true);
                }
                if (notNullJackson) {
                    configurator.getAdditionalProperties().put("notNullJacksonAnnotation", true);
                }
                if (ignoreUnknownProperties) {
                    configurator.getAdditionalProperties().put("ignoreUnknownProperties", true);
                }
                config.getPropertyNames().forEach(name -> {
                    if (name.startsWith("quarkus.camel.openapi.codegen.additional-properties")) {
                        String key = name.substring("quarkus.camel.openapi.codegen.additional-properties.".length());
                        String value = (String)config.getValue(name, String.class);
                        if (configurator.getAdditionalProperties().containsKey(key)) {
                            LOG.warn((Object)("Overriding existing property: " + key + " with value: " + value));
                        }
                        if (value.equals("true") || value.equals("false")) {
                            configurator.getAdditionalProperties().put(key, Boolean.parseBoolean(value));
                        } else {
                            configurator.getAdditionalProperties().put(key, value);
                        }
                    }
                });
                ClientOptInput input = configurator.toClientOptInput();
                new DefaultGenerator().opts(input).generate();
            }
            return true;
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to generate java files from json file in " + String.valueOf(context.inputDir().toAbsolutePath()), (Throwable)e);
        }
    }
}

