/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.velocity.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.camel.component.velocity.CamelVelocityClasspathResourceLoader;
import org.jboss.jandex.IndexView;

class VelocityProcessor {
    private static final String FEATURE = "camel-velocity";

    VelocityProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageResourceBuildItem initResources() {
        return new NativeImageResourceBuildItem(new String[]{"org/apache/velocity/runtime/defaults/velocity.properties", "org/apache/velocity/runtime/defaults/directive.properties"});
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        ArrayList dtos = index.getKnownClasses().stream().map(ci -> ci.name().toString()).filter(n -> n.startsWith("org.apache.velocity.runtime") || n.startsWith("org.apache.velocity.util.introspection")).collect(Collectors.toCollection(ArrayList::new));
        dtos.add(CamelVelocityClasspathResourceLoader.class.getName());
        return new ReflectiveClassBuildItem(false, false, dtos.toArray(new String[dtos.size()]));
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflectionWithMethods() {
        return new ReflectiveClassBuildItem(true, false, new String[]{TreeMap.class.getName()});
    }

    @BuildStep
    IndexDependencyBuildItem registerDependencyForIndex() {
        return new IndexDependencyBuildItem("org.apache.velocity", "velocity-engine-core");
    }
}

